/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.config.packets;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

@RegisterFDPacket(value="fdlib:trigger_clientside_config_reload")
public class TriggerClientsideConfigReloadPacket
extends FDPacket {
    private boolean sendMessages;

    public TriggerClientsideConfigReloadPacket(boolean sendMessages) {
        this.sendMessages = sendMessages;
    }

    public TriggerClientsideConfigReloadPacket(FriendlyByteBuf buf) {
        this.sendMessages = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.sendMessages);
    }

    @Override
    public void clientAction(Supplier<NetworkEvent.Context> context) {
        Player player = FDClientHelpers.getClientPlayer();
        for (Map.Entry v : FDRegistries.CONFIGS.get().getEntries()) {
            JsonConfig config = (JsonConfig)v.getValue();
            if (!config.isClientside()) continue;
            if (player != null && this.sendMessages) {
                player.m_213846_((Component)Component.m_237113_((String)("Reloading client config: " + config.getName())).m_130940_(ChatFormatting.GREEN));
            }
            config.loadFromDisk();
            if (player == null || !this.sendMessages) continue;
            player.m_213846_((Component)Component.m_237113_((String)"Reload complete").m_130940_(ChatFormatting.GREEN));
        }
    }

    @Override
    public void serverAction(Supplier<NetworkEvent.Context> context) {
    }
}

