/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.hud.bossbars;

import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.systems.hud.bossbars.FDBossBarFactory;
import com.finderfeed.fdlib.systems.hud.bossbars.packets.AddPlayerToBossBarPacket;
import com.finderfeed.fdlib.systems.hud.bossbars.packets.BossBarEventPacket;
import com.finderfeed.fdlib.systems.hud.bossbars.packets.RemovePlayerFromBossBarPacket;
import com.finderfeed.fdlib.systems.hud.bossbars.packets.SetBossBarProgressPacket;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.RegistryObject;

public class FDServerBossBar {
    private RegistryObject<FDBossBarFactory<?>> bossBarHolder;
    private UUID uuid;
    private Entity entity;
    private Set<ServerPlayer> players = new HashSet<ServerPlayer>();
    private float percentage = 0.0f;

    public FDServerBossBar(RegistryObject<FDBossBarFactory<?>> holder, Entity entity) {
        this.uuid = entity.m_20148_();
        this.entity = entity;
        this.bossBarHolder = holder;
    }

    public FDServerBossBar(RegistryObject<FDBossBarFactory<?>> holder) {
        this.uuid = UUID.randomUUID();
        this.entity = null;
        this.bossBarHolder = holder;
    }

    public void setPercentage(float percentage) {
        this.percentage = percentage;
        for (ServerPlayer player : this.players) {
            FDPacketHandler.INSTANCE.sendTo((Object)new SetBossBarProgressPacket(this, percentage), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void addPlayer(ServerPlayer player) {
        this.players.add(player);
        FDPacketHandler.INSTANCE.sendTo((Object)new AddPlayerToBossBarPacket(this), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void removePlayer(ServerPlayer player) {
        this.players.remove(player);
        FDPacketHandler.INSTANCE.sendTo((Object)new RemovePlayerFromBossBarPacket(this), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void broadcastEvent(int eventId, int data) {
        for (ServerPlayer player : this.players) {
            FDPacketHandler.INSTANCE.sendTo((Object)new BossBarEventPacket(this, eventId, data), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public RegistryObject<FDBossBarFactory<?>> getBossBarHolder() {
        return this.bossBarHolder;
    }
}

