/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.music;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.systems.music.FDMusic;
import com.finderfeed.fdlib.systems.music.data.FDMusicData;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.openal.AL11;

@Mod.EventBusSubscriber(modid="fdlib", value={Dist.CLIENT})
public class FDMusicSystem {
    private static final HashMap<UUID, FDMusic> ACTIVE_MUSIC = new HashMap();
    private static boolean musicWasPlaying = false;

    @SubscribeEvent
    public static void tickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        FDMusicSystem.muteAllMusicBesidesFDMusic();
        FDMusicSystem.tickMusic();
    }

    private static void muteAllMusicBesidesFDMusic() {
        float volume = -1.0f;
        if (!ACTIVE_MUSIC.isEmpty()) {
            musicWasPlaying = true;
            volume = 0.0f;
        } else if (musicWasPlaying) {
            volume = FDClientHelpers.getCurrentMusicVolume();
            musicWasPlaying = false;
        }
        if (volume != -1.0f) {
            float finalVolume = volume;
            musicWasPlaying = true;
            SoundEngine soundEngine = FDClientHelpers.getSoundEngine();
            Map instanceToChannel = soundEngine.f_120226_;
            List<SoundInstance> instances = FDMusicSystem.getAllFDSoundInstances();
            for (Map.Entry i : instanceToChannel.entrySet()) {
                SoundInstance soundInstance = (SoundInstance)i.getKey();
                if (soundInstance.m_8070_() != SoundSource.MUSIC || instances.contains(soundInstance)) continue;
                ChannelAccess.ChannelHandle channelHandle = (ChannelAccess.ChannelHandle)i.getValue();
                channelHandle.m_120154_(channel -> channel.m_83666_(finalVolume));
            }
        }
    }

    public static FDMusic getMusic(UUID uuid) {
        return ACTIVE_MUSIC.get(uuid);
    }

    private static List<SoundInstance> getAllFDSoundInstances() {
        ArrayList<SoundInstance> instances = new ArrayList<SoundInstance>();
        for (FDMusic inst : ACTIVE_MUSIC.values()) {
            instances.addAll(inst.allSoundInstances());
        }
        return instances;
    }

    public static void endMusic(UUID uuid, int fadeOutTime) {
        FDMusic fdMusic = ACTIVE_MUSIC.get(uuid);
        if (fdMusic != null) {
            fdMusic.triggerMusicEnd(fadeOutTime);
        }
    }

    public static void addMusic(FDMusicData fdMusicData) {
        if (!ACTIVE_MUSIC.containsKey(fdMusicData.getMusicSourceUUID())) {
            ACTIVE_MUSIC.put(fdMusicData.getMusicSourceUUID(), new FDMusic(fdMusicData));
        }
    }

    private static void tickMusic() {
        Iterator<Map.Entry<UUID, FDMusic>> iterator = ACTIVE_MUSIC.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, FDMusic> pair = iterator.next();
            FDMusic music = pair.getValue();
            if (music.hasFinishedPlaying()) {
                music.onFinishPlaying();
                iterator.remove();
                continue;
            }
            music.tick();
        }
    }

    @SubscribeEvent
    public static void clearSounds(ClientPlayerNetworkEvent.LoggingOut event) {
        ACTIVE_MUSIC.clear();
    }

    @SubscribeEvent
    public static void renderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        FDMusicSystem.musicRenderTick(event.renderTickTime);
    }

    public static void musicRenderTick(float pticks) {
        for (FDMusic music : ACTIVE_MUSIC.values()) {
            music.renderTick(pticks);
        }
    }

    @Mod.EventBusSubscriber(modid="fdlib", value={Dist.CLIENT})
    public static class StreamingSourcesBufferLengthCache {
        public static final HashMap<Integer, Float> sourceToProcessedBufferSecondLength = new HashMap();

        @SubscribeEvent
        public static void deleteFinishedSources(TickEvent.RenderTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            try {
                Iterator<Map.Entry<Integer, Float>> iterator = sourceToProcessedBufferSecondLength.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Float> pair = iterator.next();
                    int source = pair.getKey();
                    if (!AL11.alIsSource((int)source)) {
                        iterator.remove();
                        continue;
                    }
                    if (AL11.alGetSourcei((int)source, (int)4112) != 4116) continue;
                    iterator.remove();
                }
            }
            catch (ConcurrentModificationException e) {
                FDLib.LOGGER.warn("Tried to remove processed buffers but encountered concurrent modification exception, suppressing...");
            }
        }

        public static void onSoundEngineStop() {
            sourceToProcessedBufferSecondLength.clear();
        }

        public static void onChannelStop(int source) {
            sourceToProcessedBufferSecondLength.remove(source);
        }

        public static void onChannelHandleRelease(int source) {
            sourceToProcessedBufferSecondLength.remove(source);
        }

        public static void onProcessedBuffersRemoval(int source, int[] processedBuffers) {
            float fullSeconds = 0.0f;
            for (int buffer : processedBuffers) {
                int bytes = AL11.alGetBufferi((int)buffer, (int)8196);
                int channels = AL11.alGetBufferi((int)buffer, (int)8195);
                int bits = AL11.alGetBufferi((int)buffer, (int)8194);
                int frequency = AL11.alGetBufferi((int)buffer, (int)8193);
                try {
                    int samples = bytes * 8 / (channels * bits);
                    float seconds = (float)samples / (float)frequency;
                    fullSeconds += seconds;
                }
                catch (ArithmeticException e) {
                    FDLib.LOGGER.warn("Tried to cache length in seconds of a streaming sound source but failed, tell author of FDLib to fix his shit. Buffer attributes - Bytes: %d, Channels: %d, Bits: %d, Frequency: %d".formatted(bytes, channels, bits, frequency));
                }
            }
            float currentLength = sourceToProcessedBufferSecondLength.computeIfAbsent(source, i -> Float.valueOf(0.0f)).floatValue();
            sourceToProcessedBufferSecondLength.put(source, Float.valueOf(fullSeconds + currentLength));
        }
    }
}

