/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.shake;

import com.finderfeed.fdlib.systems.shake.FDScreenShake;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PositionedScreenShake
extends FDScreenShake {
    private Vec3 pos;
    private double maxDistance;
    private ComplexEasingFunction easingFunction;

    public PositionedScreenShake(FDShakeData data, Vec3 pos, double maxDistance) {
        super(data);
        this.pos = pos;
        this.easingFunction = ComplexEasingFunction.builder().addArea(data.getInTime(), FDEasings::easeIn).addArea(data.getStayTime(), FDEasings::one).addArea(data.getOutTime(), FDEasings::reversedEaseOut).build();
        this.maxDistance = maxDistance;
    }

    @Override
    public void process(PoseStack projection, int time, float partialTicks) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        double distToCamera = camera.m_90583_().m_82546_(this.pos).m_82553_();
        if (distToCamera > this.maxDistance) {
            return;
        }
        double pdist = distToCamera / this.maxDistance * 2.0;
        double distStrength = Math.exp(-pdist * pdist);
        Vec3 cameraPos = camera.m_90583_();
        Vec3 look = Minecraft.m_91087_().f_91074_.m_20154_();
        Vec3 left = new Vec3(0.0, 1.0, 0.0).m_82537_(look);
        Vec3 b = this.pos.m_82546_(cameraPos);
        Vec3 proj = FDMathUtil.projectVectorOntoPlane(b, look);
        Vec3 up = look.m_82537_(left);
        double angle = FDMathUtil.angleBetweenVectors(up, proj);
        if (Double.isNaN(angle)) {
            angle = 0.0;
        }
        int duration = this.getData().duration();
        float t = Mth.m_14036_((float)((float)time + partialTicks), (float)0.0f, (float)duration);
        float p = t / (float)duration;
        float s = p * (float)Math.PI * 2.0f * this.getData().getFrequency();
        if (proj.m_82526_(left) < 0.0) {
            angle = -angle;
        }
        Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f).rotateZ((float)(angle + 1.5707963705062866));
        float amplitude = this.getData().getAmplitude();
        float strength = this.easingFunction.apply(t);
        projection.m_252781_(new Quaternionf(new AxisAngle4f((float)Math.toRadians(Math.sin(s + (float)Math.PI) * (double)amplitude * (double)strength * distStrength), axis.x, axis.y, axis.z)));
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public void setPos(Vec3 pos) {
        this.pos = pos;
    }
}

