/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.radial_earthquake;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedBossBuddy;
import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterEntity;
import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterSettings;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RadialEarthquakeEntity
extends Entity
implements AutoSerializable {
    @SerializableField
    public float damage;
    @SerializableField
    public int endRadius = 10;
    @SerializableField
    public float speed;
    @SerializableField
    public float current = 0.0f;
    @SerializableField
    private int previousRadius = -1;

    public RadialEarthquakeEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public static RadialEarthquakeEntity summon(Level level, BlockPos pos, int startRadius, int endRadius, float speed, float damage) {
        RadialEarthquakeEntity radialEarthquakeEntity = new RadialEarthquakeEntity(BossEntities.RADIAL_EARTHQUAKE.get(), level);
        radialEarthquakeEntity.speed = speed;
        radialEarthquakeEntity.current = startRadius;
        radialEarthquakeEntity.endRadius = endRadius;
        radialEarthquakeEntity.damage = damage;
        radialEarthquakeEntity.m_146884_(pos.m_252807_());
        level.m_7967_((Entity)radialEarthquakeEntity);
        return radialEarthquakeEntity;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            int currentRad = (int)this.current;
            if (currentRad != this.previousRadius) {
                for (int i = this.previousRadius + 1; i <= currentRad; ++i) {
                    this.spawnAndDamageWithRadius(i);
                }
            }
            this.previousRadius = currentRad;
            this.current += this.speed;
            if (this.current >= (float)this.endRadius) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void spawnAndDamageWithRadius(int rad) {
        AABB box = new AABB((double)(-rad), -0.1, (double)(-rad), (double)rad, 1.0, (double)rad).m_82383_(this.m_20182_());
        Predicate<LivingEntity> predicate = entity -> {
            double dist = entity.m_20182_().m_82542_(1.0, 0.0, 1.0).m_82554_(this.m_20182_().m_82542_(1.0, 0.0, 1.0));
            return !(entity instanceof ChesedBossBuddy) && Math.abs(dist - (double)rad) <= 1.5;
        };
        List entities = this.m_9236_().m_6443_(LivingEntity.class, box, predicate);
        for (LivingEntity entity2 : entities) {
            entity2.m_6469_(BossDamageSources.CHESED_EARTHQUAKE_SOURCE, this.damage);
        }
        Vec3 b = new Vec3((double)rad, 0.0, 0.0);
        float angle = rad != 0 ? 0.5f / (float)rad : (float)Math.PI * 2;
        BlockPos prevPos = null;
        Vec3 tpos = this.m_20182_();
        BossUtil.posEvent((ServerLevel)this.m_9236_(), tpos, 2, rad, 60.0);
        for (float i = 0.0f; i < (float)Math.PI * 2; i += angle) {
            Vec3 pos = tpos.m_82549_(b.m_82524_(i));
            BlockPos ppos = FDMathUtil.vec3ToBlockPos((Vec3)pos);
            if (!ppos.equals(prevPos)) {
                Vec3 c = ppos.m_252807_();
                Vec3 dir = tpos.m_82546_(c).m_82542_(1.0, 0.0, 1.0).m_82541_().m_82520_(0.0, 1.0, 0.0);
                EarthShatterEntity earthShatterEntity = EarthShatterEntity.summon(this.m_9236_(), ppos, EarthShatterSettings.builder().direction(dir).stayTime(this.f_19796_.m_188503_(4)).upTime(4 - this.f_19796_.m_188503_(4)).downTime(4 - this.f_19796_.m_188503_(4)).build());
            }
            prevPos = ppos;
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        this.autoLoad(tag);
    }

    protected void m_7380_(CompoundTag tag) {
        this.autoSave(tag);
    }
}

