/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mayaworld.init;

import net.mcreator.mayaworld.entity.EvilSpiritEntity;
import net.mcreator.mayaworld.entity.FollowerCultEntity;
import net.mcreator.mayaworld.entity.HeadCultPatrolEntity;
import net.mcreator.mayaworld.entity.HeadMayanCultEntity;
import net.mcreator.mayaworld.entity.MayaIndianHunterEntity;
import net.mcreator.mayaworld.entity.MayaWarsEntity;
import net.mcreator.mayaworld.entity.MayanIndianEntity;
import net.mcreator.mayaworld.entity.MinerMayaEntity;
import net.mcreator.mayaworld.entity.SpiritMediavonHeroEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MayaWorldModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"maya_world_");
    public static final DeferredHolder<EntityType<?>, EntityType<MayanIndianEntity>> MAYAN_INDIAN = MayaWorldModEntities.register("mayan_indian", EntityType.Builder.of(MayanIndianEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<MayaWarsEntity>> MAYA_WARS = MayaWorldModEntities.register("maya_wars", EntityType.Builder.of(MayaWarsEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<MinerMayaEntity>> MINER_MAYA = MayaWorldModEntities.register("miner_maya", EntityType.Builder.of(MinerMayaEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<MayaIndianHunterEntity>> MAYA_INDIAN_HUNTER = MayaWorldModEntities.register("maya_indian_hunter", EntityType.Builder.of(MayaIndianHunterEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<FollowerCultEntity>> FOLLOWER_CULT = MayaWorldModEntities.register("follower_cult", EntityType.Builder.of(FollowerCultEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<HeadMayanCultEntity>> HEAD_MAYAN_CULT = MayaWorldModEntities.register("head_mayan_cult", EntityType.Builder.of(HeadMayanCultEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 1.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<HeadCultPatrolEntity>> HEAD_CULT_PATROL = MayaWorldModEntities.register("head_cult_patrol", EntityType.Builder.of(HeadCultPatrolEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<EvilSpiritEntity>> EVIL_SPIRIT = MayaWorldModEntities.register("evil_spirit", EntityType.Builder.of(EvilSpiritEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<SpiritMediavonHeroEntity>> SPIRIT_MEDIAVON_HERO = MayaWorldModEntities.register("spirit_mediavon_hero", EntityType.Builder.of(SpiritMediavonHeroEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.3f, 2.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maya_world_", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MayanIndianEntity.init(event);
        MayaWarsEntity.init(event);
        MinerMayaEntity.init(event);
        MayaIndianHunterEntity.init(event);
        FollowerCultEntity.init(event);
        HeadMayanCultEntity.init(event);
        HeadCultPatrolEntity.init(event);
        EvilSpiritEntity.init(event);
        SpiritMediavonHeroEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MAYAN_INDIAN.get(), MayanIndianEntity.createAttributes().build());
        event.put((EntityType)MAYA_WARS.get(), MayaWarsEntity.createAttributes().build());
        event.put((EntityType)MINER_MAYA.get(), MinerMayaEntity.createAttributes().build());
        event.put((EntityType)MAYA_INDIAN_HUNTER.get(), MayaIndianHunterEntity.createAttributes().build());
        event.put((EntityType)FOLLOWER_CULT.get(), FollowerCultEntity.createAttributes().build());
        event.put((EntityType)HEAD_MAYAN_CULT.get(), HeadMayanCultEntity.createAttributes().build());
        event.put((EntityType)HEAD_CULT_PATROL.get(), HeadCultPatrolEntity.createAttributes().build());
        event.put((EntityType)EVIL_SPIRIT.get(), EvilSpiritEntity.createAttributes().build());
        event.put((EntityType)SPIRIT_MEDIAVON_HERO.get(), SpiritMediavonHeroEntity.createAttributes().build());
    }
}

