/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.screens.SGJourneyContainerScreen;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.menu.BatteryMenu;

public class BatteryScreen
extends SGJourneyContainerScreen<BatteryMenu> {
    private static final ResourceLocation TEXTURE = StargateJourney.sgjourneyLocation("textures/gui/battery.png");

    public BatteryScreen(BatteryMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderEnergy(graphics, x + 44, y + 18);
        this.itemHint(graphics, TEXTURE, x + 8, y + 36, 88, 166, 0);
        this.itemHint(graphics, TEXTURE, x + 152, y + 36, 104, 166, 1);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.energyTooltip(graphics, 44, 18, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderEnergy(GuiGraphics graphics, int x, int y) {
        float percentage = (float)((BatteryMenu)this.menu).getEnergy() / (float)((BatteryMenu)this.menu).getMaxEnergy();
        int actual = Math.round(52.0f * percentage);
        graphics.blit(TEXTURE, x, y + 52 - actual, 0, 166, 88, actual);
    }

    protected void energyTooltip(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        this.tooltip(graphics, mouseX, mouseY, x, y, 88, 52, new Component[]{Component.translatable((String)"tooltip.sgjourney.energy").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(((BatteryMenu)this.menu).getEnergy(), ((BatteryMenu)this.menu).getMaxEnergy())))).withStyle(ChatFormatting.DARK_RED)});
    }

    @Override
    protected boolean hasItem(int slot) {
        return ((BatteryMenu)this.menu).hasItem(slot);
    }
}

