/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.screens.SGJourneyContainerScreen;
import net.povstalec.sgjourney.client.widgets.InterfaceModeButton;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;
import net.povstalec.sgjourney.common.menu.InterfaceMenu;
import net.povstalec.sgjourney.common.misc.ComponentHelper;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class InterfaceScreen
extends SGJourneyContainerScreen<InterfaceMenu> {
    private static final ResourceLocation TEXTURE = StargateJourney.sgjourneyLocation("textures/gui/interface_gui.png");
    protected EditBox commandEdit;

    public InterfaceScreen(InterfaceMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    public static long parsePositiveOrZero(String text) {
        try {
            long value = Long.parseLong(text);
            return value > 0L ? value : 0L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    protected boolean isShiftDown() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344);
    }

    public InterfaceMode getMode() {
        return ((InterfaceMenu)this.menu).getMode();
    }

    protected void init() {
        this.commandEdit = new EditBox(this.font, this.width / 2 - 54, this.height / 2 - 66, 124, 20, (Component)Component.translatable((String)"tooltip.sgjourney.energy_target"));
        this.commandEdit.setFilter(text -> {
            if (text.isEmpty()) {
                return true;
            }
            try {
                return Long.parseLong(text) >= 0L;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.commandEdit.setMaxLength(19);
        this.addWidget((GuiEventListener)this.commandEdit);
        this.setInitialFocus((GuiEventListener)this.commandEdit);
        this.commandEdit.setResponder(text -> ((InterfaceMenu)this.menu).setEnergyTargetAndMode(InterfaceScreen.parsePositiveOrZero(text), ((InterfaceMenu)this.menu).getMode()));
        this.commandEdit.setValue(String.valueOf(((InterfaceMenu)this.menu).getEnergyTarget()));
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)new InterfaceModeButton(x + 9, y + 19, (Component)Component.empty(), (Component)Component.empty(), button -> {
            if (this.isShiftDown()) {
                ((InterfaceMenu)this.menu).setEnergyTargetAndMode(InterfaceScreen.parsePositiveOrZero(this.commandEdit.getValue()), ((InterfaceMenu)this.menu).getMode().previous(((InterfaceMenu)this.menu).getInterfaceType().hasAdvancedCrystalMethods()));
            } else {
                ((InterfaceMenu)this.menu).setEnergyTargetAndMode(InterfaceScreen.parsePositiveOrZero(this.commandEdit.getValue()), ((InterfaceMenu)this.menu).getMode().next(((InterfaceMenu)this.menu).getInterfaceType().hasAdvancedCrystalMethods()));
            }
        }, this));
        super.init();
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderEnergyVertical(graphics, TEXTURE, x + 162, y + 17, 6, 138, 176, 0, ((InterfaceMenu)this.menu).getEnergy(), ((InterfaceMenu)this.menu).getMaxEnergy());
    }

    protected void modeTooltip(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height, Component name, Component ... components) {
        if (this.isHovering(x, y, width, height, mouseX, mouseY)) {
            ArrayList<Component> tooltips = new ArrayList<Component>();
            tooltips.add(name);
            tooltips.addAll(List.of(components));
            graphics.renderComponentTooltip(this.font, tooltips, mouseX, mouseY);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.commandEdit.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.tooltip(graphics, mouseX, mouseY, 33, 16, 126, 20, new Component[]{ComponentHelper.energy("tooltip.sgjourney.energy_target", ((InterfaceMenu)this.menu).getEnergyTarget()), ComponentHelper.description("tooltip.sgjourney.interface.energy_target.description")});
        this.energyTooltip(graphics, mouseX, mouseY, 162, 17, 6, 138, "tooltip.sgjourney.energy_buffer", ((InterfaceMenu)this.menu).getEnergy(), ((InterfaceMenu)this.menu).getMaxEnergy());
        this.modeTooltip(graphics, mouseX, mouseY, 9, 19, 16, 16, (Component)Component.translatable((String)"block.sgjourney.interface.mode").append(": ").append(((InterfaceMenu)this.menu).getMode().getName()), ((InterfaceMenu)this.menu).getMode().getUsage());
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        graphics.drawString(this.font, (Component)ComponentHelper.energy(((InterfaceMenu)this.menu).getEnergyBlockEnergy()), 20, 56, 0xFFFFFF, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"info.sgjourney.open_time").append(":").withStyle(ChatFormatting.DARK_AQUA), 20, 66, 0xFFFFFF, false);
        graphics.drawString(this.font, (Component)ComponentHelper.tickTimer(((InterfaceMenu)this.menu).getStargateOpenTime(), Stargate.getMaxGateOpenTime(), ChatFormatting.DARK_AQUA), 20, 76, 0xFFFFFF, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"info.sgjourney.last_traveler_time").append(":").withStyle(ChatFormatting.DARK_PURPLE), 20, 86, 0xFFFFFF, false);
        graphics.drawString(this.font, (Component)Component.literal((String)Conversion.ticksToString(((InterfaceMenu)this.menu).getStargateTimeSinceLastTraveler())).withStyle(ChatFormatting.DARK_PURPLE), 20, 96, 0xFFFFFF, false);
    }
}

