/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.render.FluidTankRenderer;
import net.povstalec.sgjourney.common.menu.LiquidizerMenu;

public abstract class LiquidizerScreen
extends AbstractContainerScreen<LiquidizerMenu> {
    private final ResourceLocation texture;
    private FluidTankRenderer renderer;

    public LiquidizerScreen(LiquidizerMenu menu, ResourceLocation texture, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.texture = texture;
    }

    public void init() {
        super.init();
        this.assignFluidRenderer();
    }

    private void assignFluidRenderer() {
        this.renderer = new FluidTankRenderer(4000L, true, 16, 54);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(this.texture, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgress(graphics, x + 28, y + 37);
        this.renderer.render(graphics, x + 12, y + 20, ((LiquidizerMenu)this.menu).getFluid1());
        this.renderer.render(graphics, x + 148, y + 20, ((LiquidizerMenu)this.menu).getFluid2());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.liquidFluid1Tooltip(graphics, 12, 20, mouseX, mouseY);
        this.liquidFluid2Tooltip(graphics, 148, 20, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderProgress(GuiGraphics graphics, int x, int y) {
        float percentage = (float)((LiquidizerMenu)this.menu).getProgress() / 100.0f;
        int actual = Math.round(119.0f * percentage);
        graphics.blit(this.texture, x, y, 0, 166, actual, 12);
    }

    protected void liquidFluid1Tooltip(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        if (this.isHovering(x, y, 16, 54, mouseX, mouseY)) {
            FluidStack fluidStack = new FluidStack(((LiquidizerMenu)this.menu).getDesiredFluid1(), 1);
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)fluidStack.getFluidType().getDescriptionId(fluidStack)).append((Component)Component.literal((String)(": " + ((LiquidizerMenu)this.menu).getFluid1().getAmount() + "/4000mB"))).withStyle(ChatFormatting.GREEN), mouseX, mouseY);
        }
    }

    protected void liquidFluid2Tooltip(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        if (this.isHovering(x, y, 16, 54, mouseX, mouseY)) {
            FluidStack fluidStack = new FluidStack(((LiquidizerMenu)this.menu).getDesiredFluid2(), 1);
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)fluidStack.getFluidType().getDescriptionId(fluidStack)).append((Component)Component.literal((String)(": " + ((LiquidizerMenu)this.menu).getFluid2().getAmount() + "/4000mB"))).withStyle(ChatFormatting.GREEN), mouseX, mouseY);
        }
    }

    public static class HeavyLiquidNaquadah
    extends LiquidizerScreen {
        public HeavyLiquidNaquadah(LiquidizerMenu menu, Inventory inventory, Component component) {
            super(menu, StargateJourney.sgjourneyLocation("textures/gui/heavy_naquadah_liquidizer_gui.png"), inventory, component);
        }
    }

    public static class LiquidNaquadah
    extends LiquidizerScreen {
        public LiquidNaquadah(LiquidizerMenu menu, Inventory inventory, Component component) {
            super(menu, StargateJourney.sgjourneyLocation("textures/gui/naquadah_liquidizer_gui.png"), inventory, component);
        }
    }
}

