/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.menu.NaquadahGeneratorMenu;

public class NaquadahGeneratorScreen
extends AbstractContainerScreen<NaquadahGeneratorMenu> {
    private static final ResourceLocation TEXTURE = StargateJourney.sgjourneyLocation("textures/gui/naquadah_generator_gui.png");

    public NaquadahGeneratorScreen(NaquadahGeneratorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight + 1);
        this.renderProgress(graphics, x + 62, y + 35);
        this.renderEnergy(graphics, x + 8, y + 62);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.energyTooltip(graphics, 8, 62, mouseX, mouseY);
    }

    protected void renderProgress(GuiGraphics graphics, int x, int y) {
        float percentage = (float)((NaquadahGeneratorMenu)this.menu).getReactionProgress() / (float)((NaquadahGeneratorMenu)this.menu).getReactionTime();
        int actual = Math.round(52.0f * percentage);
        graphics.blit(TEXTURE, x, y, 0, 174, actual, 16);
    }

    protected void renderEnergy(GuiGraphics graphics, int x, int y) {
        float percentage = (float)((NaquadahGeneratorMenu)this.menu).getEnergy() / (float)((NaquadahGeneratorMenu)this.menu).getMaxEnergy();
        int actual = Math.round(160.0f * percentage);
        graphics.blit(TEXTURE, x, y, 0, 168, actual, 6);
    }

    protected void energyTooltip(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        if (this.isHovering(x, y, 160, 6, mouseX, mouseY)) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.sgjourney.energy").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(((NaquadahGeneratorMenu)this.menu).getEnergy(), ((NaquadahGeneratorMenu)this.menu).getMaxEnergy())))).withStyle(ChatFormatting.DARK_RED), mouseX, mouseY);
        }
    }
}

