/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.povstalec.sgjourney.client.widgets.DHDButton;
import net.povstalec.sgjourney.common.menu.AbstractDHDMenu;

public abstract class DHDSymbolButton
extends DHDButton {
    protected AbstractDHDMenu menu;
    protected ResourceLocation widgets;
    protected int symbol;
    protected int widgetTextureOffsetX = 0;
    protected int widgetTextureOffsetY = 0;

    public DHDSymbolButton(int x, int y, int xSize, int ySize, AbstractDHDMenu menu, int symbol, ResourceLocation widgets) {
        super(x, y, xSize, ySize, DHDSymbolButton.symbol(menu.symbolsType, symbol), button -> menu.engageChevron(symbol));
        this.menu = menu;
        this.widgets = widgets;
        this.symbol = symbol;
    }

    protected int getYImage(boolean isHovering) {
        if (this.menu.isSymbolEngaged(this.symbol)) {
            return 2;
        }
        if (isHovering) {
            return 1;
        }
        return 0;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.widgets);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int i = this.getYImage(this.isHoveredOrFocused());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        graphics.blit(this.widgets, this.getX(), this.getY(), this.widgetTextureOffsetX, this.widgetTextureOffsetY + i * this.getHeight(), this.width, this.height);
        int j = this.getFGColor();
        graphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    private static Component symbol(String symbolsType, int i) {
        MutableComponent symbols = Component.literal((String)String.valueOf(i));
        return symbols;
    }
}

