/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.blocks.CartoucheBlock;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.packets.ClientboundCartoucheUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.AddressTable;
import org.jetbrains.annotations.NotNull;

public abstract class CartoucheEntity
extends BlockEntity
implements StructureGenEntity {
    public static final String ADDRESS_TABLE = "address_table";
    public static final String DIMENSION = "dimension";
    public static final String SYMBOLS = "symbols";
    public static final String ADDRESS = "address";
    protected StructureGenEntity.Step generationStep = StructureGenEntity.Step.GENERATED;
    private ResourceLocation addressTable;
    private ResourceLocation dimension;
    private ResourceLocation symbols;
    private Address address = new Address();

    public CartoucheEntity(BlockEntityType<?> cartouche, BlockPos pos, BlockState state) {
        super(cartouche, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.READY) {
            this.generate();
        }
        if (this.dimension != null && this.address.isEmpty()) {
            this.setAddressFromDimension();
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("generation_step", 1)) {
            this.generationStep = StructureGenEntity.Step.fromByte(tag.getByte("generation_step"));
        }
        if (tag.contains(ADDRESS_TABLE)) {
            this.addressTable = ResourceLocation.tryParse((String)tag.getString(ADDRESS_TABLE));
        }
        if (tag.contains(SYMBOLS)) {
            this.symbols = ResourceLocation.tryParse((String)tag.getString(SYMBOLS));
        }
        if (tag.contains(ADDRESS)) {
            this.address.fromArray(tag.getIntArray(ADDRESS));
        } else if (tag.contains(DIMENSION)) {
            this.dimension = ResourceLocation.tryParse((String)tag.getString(DIMENSION));
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        if (this.generationStep != StructureGenEntity.Step.GENERATED) {
            tag.putByte("generation_step", this.generationStep.byteValue());
        }
        if (this.addressTable != null) {
            tag.putString(ADDRESS_TABLE, this.addressTable.toString());
        }
        if (this.symbols != null) {
            tag.putString(SYMBOLS, this.symbols.toString());
        }
        if (!this.address.isFromDimension()) {
            tag.putIntArray(ADDRESS, this.address.toArray());
        } else if (this.dimension != null) {
            tag.putString(DIMENSION, this.dimension.toString());
        }
        super.saveAdditional(tag, registries);
    }

    public void setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    public void setSymbols(ResourceLocation symbols) {
        this.symbols = symbols;
    }

    public ResourceLocation getSymbols() {
        return this.symbols;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public ResourceLocation getAddressTable() {
        return this.addressTable;
    }

    public void setAddressFromAddressTable() {
        AddressTable addressTable = AddressTable.getAddressTable(this.level, this.addressTable);
        Address address = AddressTable.randomAddress(this.level.getServer(), addressTable);
        if (address != null) {
            this.address = address;
            if (address.isFromDimension()) {
                this.dimension = address.getDimension().location();
            }
        }
        this.addressTable = null;
        this.setChanged();
    }

    public void setAddressFromDimension() {
        this.address.fromDimension(this.level.getServer(), Conversion.locationToDimension(this.dimension));
    }

    public void setSymbolsFromLevel(Level level) {
        if (level.isClientSide()) {
            return;
        }
        this.setSymbols(Universe.get(level).getSymbols((ResourceKey<Level>)level.dimension()).location());
    }

    public void setDimensionFromLevel(Level level) {
        if (level.isClientSide()) {
            return;
        }
        this.setDimension(level.dimension().location());
    }

    protected void updateClient() {
        if (this.level.isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundCartoucheUpdatePacket(this.worldPosition, this.symbols == null ? StargateJourney.EMPTY_LOCATION : this.symbols, this.addressTable == null ? this.address.toArray() : new int[]{}), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (state.getValue(CartoucheBlock.HALF) == DoubleBlockHalf.LOWER) {
            this.updateClient();
        }
    }

    @Override
    public void generateInStructure(WorldGenLevel level, RandomSource randomSource) {
        if (this.generationStep == StructureGenEntity.Step.SETUP) {
            this.generationStep = StructureGenEntity.Step.READY;
        }
    }

    public void generate() {
        if (this.addressTable != null) {
            this.setAddressFromAddressTable();
        }
        if (this.symbols == null) {
            this.setSymbolsFromLevel(this.level);
        }
        this.generationStep = StructureGenEntity.Step.GENERATED;
    }

    public static class RedSandstone
    extends CartoucheEntity {
        public RedSandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.RED_SANDSTONE_CARTOUCHE.get(), pos, state);
        }
    }

    public static class Sandstone
    extends CartoucheEntity {
        public Sandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SANDSTONE_CARTOUCHE.get(), pos, state);
        }
    }

    public static class Stone
    extends CartoucheEntity {
        public Stone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.STONE_CARTOUCHE.get(), pos, state);
        }
    }
}

