/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.items.StargateIrisItem;
import net.povstalec.sgjourney.common.packets.ClientboundStargateUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.info.IrisInfo;

public abstract class IrisStargateEntity
extends AbstractStargateEntity
implements IrisInfo.Interface {
    protected IrisInfo irisInfo = new IrisInfo(this);

    public IrisStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork, float verticalCenterHeight, float horizontalCenterHeight) {
        super(blockEntity, defaultVariant, pos, state, totalSymbols, gen, defaultNetwork, verticalCenterHeight, horizontalCenterHeight);
    }

    public IrisStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork) {
        this(blockEntity, defaultVariant, pos, state, totalSymbols, gen, defaultNetwork, 0.5f, 0.28125f);
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgraded) {
        super.deserializeStargateInfo(tag, registries, isUpgraded);
        short irisProgress = tag.getShort("iris_progress");
        this.irisInfo().setIrisProgress(irisProgress, irisProgress);
        this.irisInfo().deserializeIrisInventory(registries, tag.getCompound("iris_inventory"));
    }

    @Override
    public CompoundTag serializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries) {
        super.serializeStargateInfo(tag, registries);
        tag.putShort("iris_progress", this.irisInfo().getIrisProgress());
        tag.put("iris_inventory", (Tag)this.irisInfo().serializeIrisInventory(registries));
        return tag;
    }

    @Override
    public IrisInfo irisInfo() {
        return this.irisInfo;
    }

    @Override
    public void doKawoosh() {
        if (!this.irisInfo().isIrisClosed()) {
            super.doKawoosh();
        }
    }

    @Override
    public void setStargateState(boolean updateInterfaces) {
        this.setStargateState(updateInterfaces, false, this.irisInfo().getShieldingState());
        this.updateClientState();
    }

    @Override
    public void getStatus(Player player) {
        if (this.level.isClientSide()) {
            return;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.iris").append((Component)Component.literal((String)": ").append((Component)(!this.irisInfo().getIris().isEmpty() ? this.irisInfo().getIris().getDisplayName() : Component.literal((String)"-")))).withStyle(ChatFormatting.GRAY));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.iris_durability").append((Component)Component.literal((String)(": " + String.valueOf(!this.irisInfo().getIris().isEmpty() ? Integer.valueOf(StargateIrisItem.getDurability(this.irisInfo().getIris())) : "-")))).withStyle(ChatFormatting.GRAY));
        if (!this.irisInfo().getIris().isEmpty() && StargateIrisItem.hasCustomTexture(this.irisInfo().getIris())) {
            player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.iris_texture").append((Component)Component.literal((String)(": " + String.valueOf(StargateIrisItem.getIrisTexture(this.irisInfo().getIris()))))).withStyle(ChatFormatting.DARK_PURPLE));
        }
        super.getStatus(player);
    }

    @Override
    public boolean updateClient() {
        if (this.level.isClientSide()) {
            return false;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundStargateUpdatePacket(this.worldPosition, this.getEnergyStored(), this.openTime, this.timeSinceLastTraveler, this.address.toArray(), this.engagedChevrons, this.kawooshTick, this.animationTick, this.irisInfo().getIrisProgress(), this.symbolInfo().pointOfOrigin(), this.symbolInfo().symbols(), this.variant, this.irisInfo().getIris()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }
}

