/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundPegasusStargateUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.Symbols;
import net.povstalec.sgjourney.common.sgjourney.info.DHDInfo;
import org.jetbrains.annotations.NotNull;

public class PegasusStargateEntity
extends IrisStargateEntity {
    public static final String ADDRESS_BUFFER = "address_buffer";
    public static final String SYMBOL_BUFFER = "symbol_buffer";
    public static final String CURRENT_SYMBOL = "current_symbol";
    public static final String DYNAMC_SYMBOLS = "dynamic_symbols";
    public static final int TOTAL_SYMBOLS = 48;
    public static final StargateInfo.ChevronLockSpeed CHEVRON_LOCK_SPEED = (StargateInfo.ChevronLockSpeed)((Object)CommonStargateConfig.pegasus_chevron_lock_speed.get());
    private final ResourceLocation backVariant = StargateJourney.sgjourneyLocation("pegasus/pegasus_back_chevron");
    public int currentSymbol = 0;
    public Address addressBuffer = new Address(true);
    public int symbolBuffer = 0;
    private boolean passedOver = false;
    protected boolean dynamicSymbols = true;

    public PegasusStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.PEGASUS_STARGATE.get(), StargateJourney.sgjourneyLocation("pegasus/pegasus"), pos, state, 48, StargateInfo.Gen.GEN_3, 3);
        this.setOpenSoundLead(13);
        this.dhdInfo = new DHDInfo(this){

            @Override
            public void updateDHD() {
                if (this.hasDHD()) {
                    this.dhd.updateDHD(!this.stargate.isConnected() || this.stargate.isConnected() && this.stargate.isDialingOut() ? PegasusStargateEntity.this.addressBuffer : new Address(), PegasusStargateEntity.this.addressBuffer.hasPointOfOrigin() || this.stargate.isConnected());
                }
            }
        };
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.GENERATED) {
            this.setLocalSymbols();
        }
    }

    @Override
    public CompoundTag serializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries) {
        super.serializeStargateInfo(tag, registries);
        tag.putBoolean(DYNAMC_SYMBOLS, this.dynamicSymbols);
        if (!this.dynamicSymbols) {
            tag.putString("point_of_origin", this.symbolInfo().pointOfOrigin().toString());
            tag.putString("symbols", this.symbolInfo().symbols().toString());
        }
        return tag;
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgraded) {
        this.dynamicSymbols = tag.getBoolean(DYNAMC_SYMBOLS);
        if (!this.dynamicSymbols) {
            this.symbolInfo().setPointOfOrigin(ResourceLocation.tryParse((String)tag.getString("point_of_origin")));
            this.symbolInfo().setSymbols(ResourceLocation.tryParse((String)tag.getString("symbols")));
        }
        super.deserializeStargateInfo(tag, registries, isUpgraded);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.addressBuffer.fromArray(tag.getIntArray(ADDRESS_BUFFER));
        this.symbolBuffer = tag.getInt(SYMBOL_BUFFER);
        this.currentSymbol = tag.getInt(CURRENT_SYMBOL);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putIntArray(ADDRESS_BUFFER, this.addressBuffer.toArray());
        tag.putInt(SYMBOL_BUFFER, this.symbolBuffer);
        tag.putInt(CURRENT_SYMBOL, this.currentSymbol);
    }

    @Override
    public ResourceLocation defaultVariant() {
        return ClientStargateConfig.pegasus_stargate_back_lights_up.get() ? this.backVariant : super.defaultVariant();
    }

    public void dynamicSymbols(boolean dynamicSymbols) {
        this.dynamicSymbols = dynamicSymbols;
        this.setChanged();
    }

    public boolean useDynamicSymbols() {
        return this.dynamicSymbols;
    }

    @Override
    public StargateInfo.Feedback dhdEngageSymbol(int symbol) {
        if (this.level.isClientSide()) {
            return StargateInfo.Feedback.NONE;
        }
        if (this.isSymbolOutOfBounds(symbol)) {
            return StargateInfo.Feedback.SYMBOL_OUT_OF_BOUNDS;
        }
        if (this.isConnected()) {
            if (symbol == 0) {
                return this.disconnectStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
            }
            return this.setRecentFeedback(StargateInfo.Feedback.ENCODE_WHEN_CONNECTED);
        }
        if (this.addressBuffer.containsSymbol(symbol)) {
            if (symbol == 0) {
                return this.resetStargate(StargateInfo.Feedback.INCOMPLETE_ADDRESS);
            }
            return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (this.addressBuffer.getLength() == this.getAddress().getLength() && !this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.StargateRotation(this.worldPosition, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.addressBuffer.addSymbol(symbol);
        this.updateInterfaceBlocks("stargate_rotation_started", this.spinClockwise());
        return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_ENCODED);
    }

    @Override
    public StargateInfo.Feedback engageSymbol(int symbol) {
        if (!this.addressBuffer.containsSymbol(symbol)) {
            this.addressBuffer.addSymbol(symbol);
        }
        return super.engageSymbol(symbol);
    }

    @Override
    protected StargateInfo.Feedback lockPrimaryChevron() {
        if (!this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.StargateRotation(this.worldPosition, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.lockPrimaryChevron();
    }

    @Override
    public StargateInfo.Feedback encodeChevron(int symbol, boolean incoming, boolean encode) {
        ++this.symbolBuffer;
        this.passedOver = false;
        if (!this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.StargateRotation(this.worldPosition, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        StargateInfo.Feedback feedback = super.encodeChevron(symbol, incoming, encode);
        if (this.addressBuffer.getLength() > this.getAddress().getLength() && !this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.StargateRotation(this.worldPosition, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return this.setRecentFeedback(feedback);
    }

    public int getChevronPosition(int chevron) {
        if (chevron < 0 || chevron > 8) {
            return 0;
        }
        return 4 * this.getEngagedChevrons()[chevron - 1];
    }

    public int getCurrentSymbol() {
        return this.currentSymbol;
    }

    private void animateSpin() {
        if (!this.isConnected() && this.addressBuffer.getLength() > this.symbolBuffer) {
            int symbol = this.addressBuffer.getSymbol(this.symbolBuffer);
            if (symbol == 0) {
                if (this.currentSymbol == this.getChevronPosition(9)) {
                    this.updateInterfaceBlocks("stargate_rotation_stopped", new Object[0]);
                    this.engageSymbol(symbol);
                } else {
                    this.symbolWork();
                }
            } else if (this.currentSymbol == this.getChevronPosition(this.symbolBuffer + 1)) {
                if (this.symbolBuffer % 2 != 0 && !this.passedOver) {
                    this.passedOver = true;
                    this.symbolWork();
                } else {
                    this.updateInterfaceBlocks("stargate_rotation_stopped", new Object[0]);
                    this.engageSymbol(symbol);
                }
            } else {
                this.symbolWork();
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PegasusStargateEntity stargate) {
        if (level.isClientSide()) {
            return;
        }
        stargate.animateSpin();
        AbstractStargateEntity.tick(level, pos, state, stargate);
        stargate.updateClient();
    }

    @Override
    public boolean updateClient() {
        if (!super.updateClient()) {
            return false;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundPegasusStargateUpdatePacket(this.worldPosition, this.symbolBuffer, this.addressBuffer.toArray(), this.currentSymbol), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    private boolean spinClockwise() {
        return this.symbolBuffer % 2 != 0;
    }

    private void symbolWork() {
        this.currentSymbol = this.spinClockwise() ? ++this.currentSymbol : --this.currentSymbol;
        if (this.currentSymbol > 35) {
            this.currentSymbol = 0;
        } else if (this.currentSymbol < 0) {
            this.currentSymbol = 35;
        }
    }

    public int getLastSymbol() {
        if (this.isConnected() && !this.isDialingOut()) {
            return 0;
        }
        return this.addressBuffer.getSymbol(this.addressBuffer.getLength() - 1);
    }

    @Override
    public int getRedstoneSymbolOutput() {
        return this.getLastSymbol() % 12 + 1;
    }

    @Override
    public int getRedstoneSegmentOutput() {
        return (this.getLastSymbol() / (this.totalSymbols / 3) + 1) * 5;
    }

    @Override
    protected void resetAddress(boolean updateInterfaces) {
        this.currentSymbol = 0;
        this.symbolBuffer = 0;
        this.addressBuffer.reset();
        super.resetAddress(updateInterfaces);
    }

    @Override
    public void playRotationSound() {
        this.stopRotationSound();
        this.spinSound.playSound();
    }

    @Override
    public void stopRotationSound() {
        this.spinSound.stopSound();
    }

    @Override
    public StargateInfo.ChevronLockSpeed getChevronLockSpeed(boolean doKawoosh) {
        return doKawoosh ? CHEVRON_LOCK_SPEED : StargateInfo.ChevronLockSpeed.FAST;
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerPegasusStargateMethods(wrapper);
    }

    @Override
    public void doWhileDialed(Address connectedAddress, int kawooshStartTicks, boolean doKawoosh, int connectionTime) {
        super.doWhileDialed(connectedAddress, kawooshStartTicks, doKawoosh, connectionTime);
        if (this.level.isClientSide()) {
            return;
        }
        if (this.currentSymbol >= 36) {
            return;
        }
        StargateInfo.ChevronLockSpeed chevronLockSpeed = this.getChevronLockSpeed(doKawoosh);
        this.currentSymbol = connectionTime / chevronLockSpeed.getMultiplier();
        this.updateClient();
    }

    public void setLocalSymbols() {
        if (!PointOfOrigin.validLocation(this.level.getServer(), this.symbolInfo().pointOfOrigin())) {
            this.symbolInfo().setPointOfOrigin(PointOfOrigin.fromDimension(this.level.getServer(), (ResourceKey<Level>)this.level.dimension()));
        }
        if (!Symbols.validLocation(this.level.getServer(), this.symbolInfo().symbols())) {
            this.symbolInfo().setSymbols(Symbols.fromDimension(this.level.getServer(), (ResourceKey<Level>)this.level.dimension()));
        }
    }

    @Override
    public void generateAdditional(StructureGenEntity.Step generationStep) {
        if (generationStep == StructureGenEntity.Step.SETUP) {
            if (!PointOfOrigin.validLocation(this.level.getServer(), this.symbolInfo().pointOfOrigin())) {
                this.symbolInfo().setPointOfOrigin(StargateJourney.EMPTY_LOCATION);
            }
            if (!Symbols.validLocation(this.level.getServer(), this.symbolInfo().symbols())) {
                this.symbolInfo().setSymbols(StargateJourney.EMPTY_LOCATION);
            }
        } else {
            this.setLocalSymbols();
        }
    }
}

