/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundRotatingStargateUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;

public abstract class RotatingStargateEntity
extends IrisStargateEntity {
    public static final String ROTATION = "rotation";
    protected final int maxRotation;
    protected final int stepsPerSymbol;
    protected final int symbolAddition;
    protected int rotation;
    protected int oldRotation;
    @Nullable
    public SoundWrapper buildupSound = null;
    protected Map<StargatePart, Integer> signalMap;
    public int previousSignalStrength;
    public int signalStrength;
    public boolean rotating;
    public int desiredRotation;
    public boolean rotateClockwise;

    public RotatingStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork, float verticalCenterHeight, float horizontalCenterHeight, int maxRotation) {
        super(blockEntity, defaultVariant, pos, state, totalSymbols, gen, defaultNetwork, verticalCenterHeight, horizontalCenterHeight);
        this.maxRotation = maxRotation;
        this.stepsPerSymbol = this.maxRotation / this.totalSymbols;
        this.symbolAddition = this.stepsPerSymbol / 2;
        this.rotation = 0;
        this.oldRotation = 0;
        this.signalMap = Maps.newHashMap();
        this.previousSignalStrength = 0;
        this.signalStrength = 0;
        this.rotating = false;
        this.desiredRotation = 0;
        this.rotateClockwise = true;
    }

    public RotatingStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork, int maxRotation) {
        this(blockEntity, defaultVariant, pos, state, totalSymbols, gen, defaultNetwork, 0.5f, 0.28125f, maxRotation);
    }

    @Override
    public CompoundTag serializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries) {
        super.serializeStargateInfo(tag, registries);
        tag.putInt(ROTATION, this.rotation);
        return tag;
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgraded) {
        if (tag.contains(ROTATION)) {
            this.rotation = tag.getInt(ROTATION);
        }
        this.oldRotation = this.rotation;
        super.deserializeStargateInfo(tag, registries, isUpgraded);
    }

    public int getRotation() {
        return this.rotation;
    }

    public double getRotationDegrees() {
        return (double)this.getRotation() / (double)this.maxRotation * 360.0;
    }

    public float getRotation(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.getRotation() : Mth.lerp((float)partialTick, (float)this.oldRotation, (float)this.rotation);
    }

    public float getRotationDegrees(float partialTick) {
        return this.getRotation(partialTick) / (float)this.maxRotation * 360.0f;
    }

    public void setRotation(int oldRotation, int rotation) {
        this.oldRotation = oldRotation;
        this.rotation = rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isRotating() {
        return this.rotation != this.oldRotation;
    }

    protected int rotationStep() {
        return 1;
    }

    public int ringDistance(int rotationA, int rotationB) {
        int distance = Math.abs(rotationA - rotationB);
        if ((float)distance > (float)this.maxRotation / 2.0f) {
            return this.maxRotation - distance;
        }
        return distance;
    }

    protected void rotateToTarget() {
        int ringDistance = this.ringDistance(this.rotation, this.desiredRotation);
        if (ringDistance == 0) {
            this.endRotation(false);
        } else if (ringDistance < this.rotationStep()) {
            this.rotate(this.rotateClockwise, ringDistance);
        } else {
            this.rotate(this.rotateClockwise);
        }
    }

    protected void rotate() {
        if (!this.isConnected()) {
            if (this.rotating) {
                this.rotateToTarget();
            } else if (this.signalStrength > 0 && this.signalStrength < 15) {
                if (this.signalStrength > 7) {
                    this.rotate(false);
                } else {
                    this.rotate(true);
                }
            } else {
                this.syncRotation();
            }
        } else if (!this.isDialingOut() && this.getKawooshTickCount() <= 0 && this.rotating) {
            this.rotateToTarget();
        } else {
            this.syncRotation();
        }
        this.setChanged();
    }

    public void rotate(boolean clockwise, int rotationStep) {
        this.oldRotation = this.rotation;
        this.rotation = clockwise ? (this.rotation -= rotationStep) : (this.rotation += rotationStep);
        if (this.rotation >= this.maxRotation) {
            this.rotation -= this.maxRotation;
            this.oldRotation -= this.maxRotation;
        } else if (this.rotation < 0) {
            this.rotation += this.maxRotation;
            this.oldRotation += this.maxRotation;
        }
        this.rotation -= this.rotation % rotationStep;
        this.setChanged();
    }

    public void rotate(boolean clockwise) {
        this.rotate(clockwise, this.rotationStep());
    }

    protected StargateInfo.Feedback rotateTo(int degrees, boolean rotateClockwise) {
        this.rotating = true;
        this.desiredRotation = degrees;
        this.rotateClockwise = rotateClockwise;
        if (!this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.RotationStartup(this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.synchronizeWithClient();
        this.updateInterfaceBlocks("stargate_rotation_started", rotateClockwise);
        return this.setRecentFeedback(StargateInfo.Feedback.ROTATING);
    }

    public StargateInfo.Feedback startRotation(int desiredSymbol, boolean rotateClockwise) {
        return this.rotateTo(desiredSymbol < 0 ? -1 : this.getDesiredRotation(desiredSymbol), rotateClockwise);
    }

    public StargateInfo.Feedback endRotation(boolean playSound) {
        if (!this.level.isClientSide() && playSound) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.RotationStop(this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!this.rotating) {
            return this.setRecentFeedback(StargateInfo.Feedback.NOT_ROTATING);
        }
        this.rotating = false;
        this.synchronizeWithClient();
        this.updateInterfaceBlocks("stargate_rotation_stopped", new Object[0]);
        return this.setRecentFeedback(StargateInfo.Feedback.ROTATION_STOPPED);
    }

    protected void syncRotation() {
        this.oldRotation = this.rotation;
        if (!this.level.isClientSide()) {
            this.synchronizeWithClient();
        }
    }

    public void playBuildupSound() {
        if (this.buildupSound.isPlaying()) {
            this.buildupSound.stopSound();
        }
        this.buildupSound.playSound();
    }

    @Override
    public void playRotationSound() {
        if (!this.spinSound.isPlaying()) {
            this.spinSound.stopSound();
            this.spinSound.playSound();
        }
    }

    @Override
    public void stopRotationSound() {
    }

    public static boolean alternatingDirection(int addressLength) {
        return addressLength % 2 == 1;
    }

    public boolean bestSymbolDirection(int desiredSymbol) {
        return this.bestRotationDirection(this.getDesiredRotation(desiredSymbol));
    }

    public boolean bestRotationDirection(int desiredRotation) {
        int rotation = this.rotation;
        double difference = desiredRotation - rotation;
        if (difference >= (double)(this.maxRotation / 2)) {
            rotation = this.maxRotation;
        } else if (difference <= (double)(-this.maxRotation / 2)) {
            rotation = -this.maxRotation;
        }
        double lowerBound = desiredRotation - 1;
        return (double)rotation > lowerBound;
    }

    protected boolean hadBestRedstoneSignalChanged() {
        this.previousSignalStrength = this.signalStrength;
        this.signalStrength = 0;
        this.signalMap.forEach((stargatePart, signal) -> {
            if (signal > this.signalStrength) {
                this.signalStrength = signal;
            }
        });
        return this.previousSignalStrength != this.signalStrength;
    }

    public void updateSignal(StargatePart part, int signal) {
        if (!((Boolean)CommonStargateConfig.enable_redstone_dialing.get()).booleanValue()) {
            return;
        }
        if (this.signalMap.containsKey((Object)part)) {
            this.signalMap.remove((Object)part);
        }
        this.signalMap.put(part, signal);
        if (this.hadBestRedstoneSignalChanged()) {
            this.manualDialing();
        }
    }

    public StargateInfo.Feedback encodeChevron() {
        if (!this.level.isClientSide()) {
            this.synchronizeWithClient();
        }
        return this.setRecentFeedback(this.engageSymbol(this.getCurrentSymbol()));
    }

    public int getDesiredRotation(int desiredSymbol) {
        return desiredSymbol * this.stepsPerSymbol;
    }

    public boolean isCurrentSymbol(int desiredSymbol) {
        return this.getDesiredRotation(desiredSymbol) == this.rotation;
    }

    public int getCurrentSymbol() {
        int symbolPosition = this.rotation + this.symbolAddition;
        int currentSymbol = symbolPosition / this.stepsPerSymbol % this.totalSymbols;
        return currentSymbol;
    }

    protected void manualDialing() {
        if (this.signalStrength == 15 && this.previousSignalStrength != this.signalStrength) {
            if (!this.isConnected()) {
                this.engageSymbol(this.getCurrentSymbol());
            } else {
                this.disconnectStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_POINT_OF_ORIGIN, true);
            }
        }
        if (!this.level.isClientSide()) {
            this.synchronizeWithClient();
        }
    }

    @Override
    public int getRedstoneSymbolOutput() {
        return this.getCurrentSymbol() % (this.totalSymbols / 3) + 1;
    }

    @Override
    public int getRedstoneSegmentOutput() {
        return (this.getCurrentSymbol() / (this.totalSymbols / 3) + 1) * 5;
    }

    protected boolean synchronizeWithClient() {
        if (this.level.isClientSide()) {
            return false;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundRotatingStargateUpdatePacket(this.worldPosition, this.rotation, this.oldRotation, this.signalStrength, this.rotating, this.rotateClockwise, this.desiredRotation), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RotatingStargateEntity stargate) {
        stargate.rotate();
        if (stargate.isRotating() && !level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(stargate.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.StargateRotation(stargate.worldPosition, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (stargate.isRotating()) {
            stargate.updateInterfaceBlocks(null, new Object[0]);
        }
        AbstractStargateEntity.tick(level, pos, state, stargate);
    }
}

