/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.RotatingStargateEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundUniverseStargateUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.Symbols;
import net.povstalec.sgjourney.common.sgjourney.info.DHDInfo;
import org.jetbrains.annotations.NotNull;

public class UniverseStargateEntity
extends RotatingStargateEntity {
    public static final String ADDRESS_BUFFER = "address_buffer";
    public static final String SYMBOL_BUFFER = "symbol_buffer";
    public static final boolean FAST_ROTATION = (Boolean)CommonStargateConfig.universe_fast_rotation.get();
    public static final int TOTAL_SYMBOLS = 36;
    public static final int MAX_ROTATION = 324;
    public static final int ROTATION_THIRD = 108;
    public static final int RESET_DEGREES = 216;
    public static final int MAX_WAIT_TICKS = 20;
    public static final StargateInfo.ChevronLockSpeed CHEVRON_LOCK_SPEED = (StargateInfo.ChevronLockSpeed)((Object)CommonStargateConfig.universe_chevron_lock_speed.get());
    public int waitTicks = 1;
    public Address addressBuffer = new Address(true);
    public int symbolBuffer = 0;
    protected int angle;

    public UniverseStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.UNIVERSE_STARGATE.get(), StargateJourney.sgjourneyLocation("universe/universe"), pos, state, 36, StargateInfo.Gen.GEN_1, 1, 324);
        this.setOpenSoundLead(8);
        this.angle = this.maxRotation / 54;
        this.symbolInfo.setPointOfOrigin(PointOfOrigin.UNIVERSAL_LOCATION);
        this.symbolInfo.setSymbols(Symbols.UNIVERSAL_LOCATION);
        this.dhdInfo = new DHDInfo(this){

            @Override
            public void updateDHD() {
                if (this.hasDHD()) {
                    this.dhd.updateDHD(!this.stargate.isConnected() || this.stargate.isConnected() && this.stargate.isDialingOut() ? UniverseStargateEntity.this.addressBuffer : new Address(), UniverseStargateEntity.this.addressBuffer.hasPointOfOrigin() || this.stargate.isConnected());
                }
            }
        };
        this.oldRotation = 216;
        this.rotation = 216;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.addressBuffer.fromArray(tag.getIntArray(ADDRESS_BUFFER));
        this.symbolBuffer = tag.getInt(SYMBOL_BUFFER);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putIntArray(ADDRESS_BUFFER, this.addressBuffer.toArray());
        tag.putInt(SYMBOL_BUFFER, this.symbolBuffer);
    }

    @Override
    public StargateInfo.Feedback dhdEngageSymbol(int symbol) {
        if (this.isSymbolOutOfBounds(symbol)) {
            return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_OUT_OF_BOUNDS);
        }
        if (this.addressBuffer.getLength() == 0 && this.address.getLength() > 0) {
            this.resetStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
        }
        if (this.isConnected()) {
            if (symbol == 0) {
                return this.disconnectStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
            }
            return this.setRecentFeedback(StargateInfo.Feedback.ENCODE_WHEN_CONNECTED);
        }
        if (symbol == 0 && !this.isConnected() && this.addressBuffer.getLength() == 0) {
            return this.setRecentFeedback(StargateInfo.Feedback.INCOMPLETE_ADDRESS);
        }
        if (this.addressBuffer.containsSymbol(symbol)) {
            if (symbol == 0) {
                return this.resetStargate(StargateInfo.Feedback.INCOMPLETE_ADDRESS);
            }
            return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (this.addressBuffer.getLength() == 0 && this.address.getLength() == 0) {
            this.startSound();
        }
        this.addressBuffer.addSymbol(symbol);
        return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_ENCODED);
    }

    @Override
    public StargateInfo.Feedback engageSymbol(int symbol) {
        if (!this.addressBuffer.containsSymbol(symbol)) {
            this.addressBuffer.addSymbol(symbol);
        }
        return super.engageSymbol(symbol);
    }

    @Override
    public StargateInfo.Feedback encodeChevron(int symbol, boolean incoming, boolean encode) {
        ++this.symbolBuffer;
        ++this.waitTicks;
        return super.encodeChevron(symbol, incoming, encode);
    }

    public void startSound() {
        if (!this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.UniverseStart(this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean dialFromBuffer() {
        return !this.addressBuffer.isEmpty();
    }

    public void bufferDialing() {
        if (this.waitTicks != 0) {
            this.waitTicks = this.waitTicks >= 20 ? 0 : ++this.waitTicks;
            return;
        }
        if (!this.isConnected() && this.addressBuffer.getLength() > this.symbolBuffer) {
            if (!this.isRotating()) {
                this.startRotation(this.addressBuffer.getSymbol(this.symbolBuffer), (Boolean)CommonStargateConfig.universe_best_direction.get() != false ? this.bestSymbolDirection(this.addressBuffer.getSymbol(this.symbolBuffer)) : UniverseStargateEntity.alternatingDirection(this.address.getLength()));
            }
            if (this.rotation == this.desiredRotation) {
                this.engageSymbol(this.getCurrentSymbol());
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, UniverseStargateEntity stargate) {
        if (stargate.dialFromBuffer() && !level.isClientSide()) {
            stargate.bufferDialing();
        }
        RotatingStargateEntity.tick(level, pos, state, stargate);
    }

    @Override
    public int getRedstoneSymbolOutput() {
        int currentSymbol = this.getCurrentSymbol();
        if (currentSymbol == -1) {
            return 0;
        }
        return currentSymbol % 12 + 1;
    }

    @Override
    public int getRedstoneSegmentOutput() {
        return (this.rotation / 108 + 1) * 5;
    }

    @Override
    public int getDesiredRotation(int desiredSymbol) {
        int whole = desiredSymbol / 4;
        int leftover = desiredSymbol % 4;
        return 3 * (this.angle / 2) + whole * this.maxRotation / 9 + this.angle * leftover;
    }

    @Override
    public int getCurrentSymbol() {
        int segment6 = this.rotation / 6;
        if (segment6 % 6 == 0 || segment6 % 6 == 5) {
            return -1;
        }
        int emptySegments = 2 * (segment6 / 6) + 1;
        return segment6 - emptySegments;
    }

    @Override
    protected int rotationStep() {
        return FAST_ROTATION ? (this.rotating ? 3 : 2) : 2;
    }

    @Override
    public StargateInfo.Feedback resetStargate(StargateInfo.Feedback feedback, boolean updateInterfaces) {
        super.resetStargate(feedback, updateInterfaces);
        if (this.rotation != 216) {
            this.rotateTo(216, this.bestRotationDirection(216));
        }
        return feedback;
    }

    @Override
    protected void resetAddress(boolean updateInterfaces) {
        this.waitTicks = 1;
        this.symbolBuffer = 0;
        this.addressBuffer.reset();
        super.resetAddress(updateInterfaces);
    }

    @Override
    public boolean updateClient() {
        if (!super.updateClient()) {
            return false;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundUniverseStargateUpdatePacket(this.worldPosition, this.symbolBuffer, this.addressBuffer.toArray()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    @Override
    public StargateInfo.ChevronLockSpeed getChevronLockSpeed(boolean doKawoosh) {
        return doKawoosh ? CHEVRON_LOCK_SPEED : StargateInfo.ChevronLockSpeed.FAST;
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerUniverseStargateMethods(wrapper);
    }

    @Override
    public void doWhileDialed(Address connectedAddress, int kawooshStartTicks, boolean doKawoosh, int connectionTime) {
        StargateInfo.ChevronLockSpeed chevronLockSpeed;
        super.doWhileDialed(connectedAddress, kawooshStartTicks, doKawoosh, connectionTime);
        if (this.level.isClientSide()) {
            return;
        }
        if (connectionTime == 1) {
            this.startSound();
            this.startRotation(-1, true);
        }
        if (connectionTime == (chevronLockSpeed = this.getChevronLockSpeed(doKawoosh)).getChevronWaitTicks() * 8) {
            this.endRotation(false);
        }
    }
}

