/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractCrystallizerEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.items.StargateUpgradeItem;
import net.povstalec.sgjourney.common.recipe.CrystalRecipeInput;
import net.povstalec.sgjourney.common.recipe.CrystallizerRecipe;

public class CrystallizerEntity
extends AbstractCrystallizerEntity {
    public CrystallizerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CRYSTALLIZER.get(), pos, state);
    }

    @Override
    public Fluid getDesiredFluid() {
        return (Fluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get();
    }

    @Override
    protected boolean hasIngredients() {
        Level level = this.getLevel();
        SimpleContainer inventory = new SimpleContainer(5);
        inventory.setItem(0, this.crystalBaseHandler.getStackInSlot(0));
        inventory.setItem(1, this.primaryIngredientHandler.getStackInSlot(0));
        inventory.setItem(2, this.secondaryIngredientHandler.getStackInSlot(0));
        inventory.setItem(3, this.outputHandler.getStackInSlot(0));
        inventory.setItem(4, this.fluidInputHandler.getStackInSlot(0));
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)CrystallizerRecipe.Type.CRYSTALLIZING, (RecipeInput)new CrystalRecipeInput(this.crystalBaseHandler.getStackInSlot(0), this.primaryIngredientHandler.getStackInSlot(0), this.secondaryIngredientHandler.getStackInSlot(0)), level);
        if (!recipe.isPresent()) {
            return false;
        }
        if (!((Boolean)CommonStargateConfig.enable_classic_stargate_upgrades.get()).booleanValue() && ((CrystallizerRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.getServer().registryAccess()).getItem() instanceof StargateUpgradeItem) {
            return false;
        }
        return CrystallizerEntity.hasSpaceInOutputSlot(inventory, ((CrystallizerRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.getServer().registryAccess()));
    }

    @Override
    protected void crystallize() {
        Level level = this.getLevel();
        SimpleContainer inventory = new SimpleContainer(5);
        inventory.setItem(0, this.crystalBaseHandler.getStackInSlot(0));
        inventory.setItem(1, this.primaryIngredientHandler.getStackInSlot(0));
        inventory.setItem(2, this.secondaryIngredientHandler.getStackInSlot(0));
        inventory.setItem(3, this.outputHandler.getStackInSlot(0));
        inventory.setItem(4, this.fluidInputHandler.getStackInSlot(0));
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)CrystallizerRecipe.Type.CRYSTALLIZING, (RecipeInput)new CrystalRecipeInput(this.crystalBaseHandler.getStackInSlot(0), this.primaryIngredientHandler.getStackInSlot(0), this.secondaryIngredientHandler.getStackInSlot(0)), level);
        if (this.hasIngredients()) {
            ItemStack outputStack;
            this.useUpItems((CrystallizerRecipe)((RecipeHolder)recipe.get()).value(), 0);
            if (((CrystallizerRecipe)((RecipeHolder)recipe.get()).value()).depletePrimary()) {
                this.useUpItems((CrystallizerRecipe)((RecipeHolder)recipe.get()).value(), 1);
            }
            if (((CrystallizerRecipe)((RecipeHolder)recipe.get()).value()).depleteSecondary()) {
                this.useUpItems((CrystallizerRecipe)((RecipeHolder)recipe.get()).value(), 2);
            }
            if ((outputStack = this.outputHandler.getStackInSlot(0)).isEmpty()) {
                this.outputHandler.setStackInSlot(0, ((CrystallizerRecipe)((RecipeHolder)recipe.get()).value()).getResultItem(null));
            } else if (((CrystallizerRecipe)((RecipeHolder)recipe.get()).value()).getResultItem(null).is(outputStack.getItem())) {
                outputStack.grow(1);
            }
            this.progress = 0;
        }
    }

    protected void useUpItems(CrystallizerRecipe recipe, int slot) {
        switch (slot) {
            case 1: {
                this.primaryIngredientHandler.extractItem(0, recipe.getAmountInSlot(1), false);
                break;
            }
            case 2: {
                this.secondaryIngredientHandler.extractItem(0, recipe.getAmountInSlot(2), false);
                break;
            }
            default: {
                this.crystalBaseHandler.extractItem(0, recipe.getAmountInSlot(0), false);
            }
        }
    }
}

