/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahGeneratorBlock;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.NaquadahFuelRodItem;
import net.povstalec.sgjourney.common.packets.ClientboundNaquadahGeneratorUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class NaquadahGeneratorEntity
extends EnergyBlockEntity {
    public static final String INVENTORY = "inventory";
    private int reactionProgress = 0;
    private final ItemStackHandler itemStackHandler = this.createHandler();
    private final Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemStackHandler);

    public NaquadahGeneratorEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, true);
    }

    @Override
    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.itemStackHandler.deserializeNBT(registries, nbt.getCompound(INVENTORY));
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put(INVENTORY, (Tag)this.itemStackHandler.serializeNBT(registries));
    }

    public boolean hasNaquadah() {
        ItemStack stack = this.itemStackHandler.getStackInSlot(0);
        if (stack.getItem() instanceof NaquadahFuelRodItem) {
            return NaquadahFuelRodItem.getFuel(stack) > 0;
        }
        return false;
    }

    public void setReactionProgress(int reactionProgress) {
        this.reactionProgress = reactionProgress;
    }

    public int getReactionProgress() {
        return this.reactionProgress;
    }

    public abstract long getReactionTime();

    public abstract long getEnergyPerTick();

    @Nullable
    public Direction getDirection() {
        BlockPos gatePos = this.getBlockPos();
        BlockState gateState = this.level.getBlockState(gatePos);
        if (gateState.getBlock() instanceof NaquadahGeneratorBlock) {
            FrontAndTop orientation = (FrontAndTop)gateState.getValue(NaquadahGeneratorBlock.ORIENTATION);
            if (orientation.top() == Direction.UP) {
                return orientation.front();
            }
            return orientation.top();
        }
        StargateJourney.LOGGER.error("Couldn't find Direction " + this.getBlockPos().toString());
        return null;
    }

    @Nullable
    public Direction getBottomDirection() {
        BlockPos pos = this.getBlockPos();
        BlockState state = this.level.getBlockState(pos);
        if (state.getBlock() instanceof NaquadahGeneratorBlock) {
            FrontAndTop orientation = (FrontAndTop)state.getValue(NaquadahGeneratorBlock.ORIENTATION);
            return orientation.front().getOpposite();
        }
        StargateJourney.LOGGER.error("Couldn't find Direction " + this.getBlockPos().toString());
        return null;
    }

    public boolean isActive() {
        BlockPos gatePos = this.getBlockPos();
        BlockState gateState = this.level.getBlockState(gatePos);
        if (gateState.getBlock() instanceof NaquadahGeneratorBlock) {
            return (Boolean)gateState.getValue((Property)NaquadahGeneratorBlock.ACTIVE);
        }
        StargateJourney.LOGGER.error("Couldn't find Active state" + this.getBlockPos().toString());
        return false;
    }

    public IItemHandler getItemHandler(Direction side) {
        return (IItemHandler)this.lazyItemHandler.get();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                NaquadahGeneratorEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.getItem() == ItemInit.NAQUADAH_FUEL_ROD.get();
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    protected boolean isCorrectEnergySide(Direction side) {
        Direction direction = this.getDirection();
        Direction bottom = this.getBottomDirection();
        if (direction != null && bottom != null) {
            return side == bottom || side == direction.getClockWise() || side == direction.getCounterClockWise();
        }
        return false;
    }

    @Override
    protected boolean receivesEnergy() {
        return false;
    }

    private void doReaction() {
        if (!this.isActive()) {
            return;
        }
        if (this.hasNaquadah() && this.reactionProgress == 0) {
            if (NaquadahFuelRodItem.depleteFuel(this.itemStackHandler.getStackInSlot(0))) {
                this.progressReaction();
            } else {
                this.itemStackHandler.extractItem(0, 1, false);
            }
        } else if (this.reactionProgress > 0 && (long)this.reactionProgress < this.getReactionTime() && this.getEnergyStored() < this.capacity() && this.canReceive(this.getEnergyPerTick())) {
            this.progressReaction();
        } else if ((long)this.reactionProgress >= this.getReactionTime()) {
            this.reactionProgress = 0;
        }
    }

    private void progressReaction() {
        this.generateEnergy(this.getEnergyPerTick());
        ++this.reactionProgress;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NaquadahGeneratorEntity generator) {
        if (level.isClientSide()) {
            return;
        }
        generator.doReaction();
        Direction direction = generator.getDirection();
        if (direction != null) {
            generator.outputEnergy(generator.getBottomDirection());
            generator.outputEnergy(direction.getClockWise());
            generator.outputEnergy(direction.getCounterClockWise());
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(generator.worldPosition).getPos(), (CustomPacketPayload)new ClientboundNaquadahGeneratorUpdatePacket(generator.worldPosition, generator.getReactionProgress(), generator.getEnergyStored()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

