/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.transporter;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransporterEntity
extends EnergyBlockEntity
implements StructureGenEntity,
Nameable {
    protected static final boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    public static final String ADD_TO_NETWORK = "add_to_network";
    public static final String ID = "transporter_id";
    public static final String CUSTOM_NAME = "custom_name";
    protected StructureGenEntity.Step generationStep = StructureGenEntity.Step.GENERATED;
    protected UUID id;
    @Nullable
    protected UUID connectionID = null;
    @Nullable
    private Component name;

    public AbstractTransporterEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.READY) {
            this.generate();
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("generation_step", 1)) {
            this.generationStep = StructureGenEntity.Step.fromByte(tag.getByte("generation_step"));
        }
        try {
            if (tag.contains(ID)) {
                this.id = UUID.fromString(tag.getString(ID));
            }
        }
        catch (IllegalArgumentException e) {
            this.setID(this.generateID());
        }
        if (tag.contains(CUSTOM_NAME, 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString(CUSTOM_NAME), (HolderLookup.Provider)registries);
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        if (this.generationStep != StructureGenEntity.Step.GENERATED) {
            tag.putByte("generation_step", this.generationStep.byteValue());
        }
        if (this.id != null) {
            tag.putString(ID, this.id.toString());
        }
        super.saveAdditional(tag, registries);
        if (this.name != null) {
            tag.putString(CUSTOM_NAME, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
    }

    public UUID generateID() {
        return UUID.randomUUID();
    }

    public void setID(UUID id) {
        this.id = id;
        this.setChanged();
        StargateJourney.LOGGER.info("Set ID to " + String.valueOf(id));
    }

    public UUID getID() {
        return this.id;
    }

    @Nullable
    public Transporter getTransporter() {
        return TransporterNetwork.get(this.level).getTransporter(this.id);
    }

    public void addTransporterToNetwork() {
        if (this.id == null) {
            this.setID(this.generateID());
        }
        TransporterNetwork.get(this.level).addTransporter(this);
        this.setChanged();
    }

    public void removeTransporterFromNetwork() {
        TransporterNetwork.get(this.level).removeTransporter(this.level, this.id);
    }

    @Override
    public void getStatus(Player player) {
        super.getStatus(player);
        if (this.level.isClientSide()) {
            return;
        }
        player.sendSystemMessage((Component)Component.literal((String)("ID: " + String.valueOf(this.id))).withStyle(ChatFormatting.AQUA));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.add_to_network").append((Component)Component.literal((String)(": " + (this.generationStep == StructureGenEntity.Step.GENERATED)))).withStyle(ChatFormatting.YELLOW));
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    protected abstract Component getDefaultName();

    public abstract boolean isConnected();

    public boolean canTransport() {
        return !this.isConnected();
    }

    public int getTimeOffset() {
        return 0;
    }

    public boolean connectTransporter(UUID connectionID) {
        this.connectionID = connectionID;
        this.setConnected(true);
        return true;
    }

    public void disconnectTransporter() {
        if (this.connectionID != null) {
            TransporterNetwork.get(this.level).terminateConnection(this.connectionID);
        }
        this.resetTransporter();
    }

    public void resetTransporter() {
        this.connectionID = null;
        this.setConnected(false);
    }

    protected void loadChunk(boolean load) {
        if (!this.level.isClientSide()) {
            this.level.getServer().getLevel(this.level.dimension()).setChunkForced(SectionPos.blockToSectionCoord((int)this.getBlockPos().getX()), SectionPos.blockToSectionCoord((int)this.getBlockPos().getZ()), load);
        }
    }

    @Nullable
    public abstract List<Entity> entitiesToTransport();

    public abstract BlockPos transportPos();

    public abstract void updateTicks(int var1);

    public abstract void setConnected(boolean var1);

    @Override
    public void generateInStructure(WorldGenLevel level, RandomSource randomSource) {
        if (this.generationStep == StructureGenEntity.Step.SETUP) {
            this.generationStep = StructureGenEntity.Step.READY;
        }
    }

    public void generate() {
        this.addTransporterToNetwork();
        this.generationStep = StructureGenEntity.Step.GENERATED;
    }
}

