/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.CartoucheEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public abstract class CartoucheBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.create((String)"orientation", Orientation.class);

    public CartoucheBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Orientation orientation = Orientation.getOrientationFromXRot(context.getPlayer());
        Direction direction = context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(ORIENTATION, (Comparable)((Object)orientation));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{HALF}).add(new Property[]{ORIENTATION});
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Direction relativeDirection;
        Direction direction = (Direction)oldState.getValue((Property)FACING);
        Orientation orientation = (Orientation)((Object)oldState.getValue(ORIENTATION));
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)oldState.getValue(HALF);
        Direction direction2 = relativeDirection = doubleblockhalf == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
        if (oldState.getBlock() != newState.getBlock()) {
            BlockPos destroyPos = pos.relative(Orientation.getMultiDirection(direction, relativeDirection, orientation));
            if (level.getBlockState(destroyPos).getBlock() instanceof CartoucheBlock) {
                level.setBlock(destroyPos, Blocks.AIR.defaultBlockState(), 3);
            }
            super.onRemove(oldState, level, pos, newState, isMoving);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity blockEntity;
            Direction direction = (Direction)state.getValue((Property)FACING);
            Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
            if (level.getBlockState(pos).getValue(HALF) == DoubleBlockHalf.UPPER) {
                pos = pos.relative(Orientation.getMultiDirection(direction, Direction.DOWN, orientation));
            }
            if ((blockEntity = level.getBlockEntity(pos)) instanceof CartoucheEntity) {
                CartoucheEntity cartouche = (CartoucheEntity)blockEntity;
                Address address = cartouche.getAddress();
                if (address.isFromDimension()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.dimension").append((Component)Component.literal((String)": ")).append(address.getDimension().location().toString()).withStyle(ChatFormatting.GREEN));
                }
                player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.address").append((Component)Component.literal((String)": ")).withStyle(ChatFormatting.YELLOW).append(address.toComponent(true)));
                if (cartouche.getSymbols() != null) {
                    player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.symbols").append((Component)Component.literal((String)(": " + String.valueOf(cartouche.getSymbols())))).withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (cartouche.getAddressTable() != null) {
                    player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.address_table").append((Component)Component.literal((String)(": " + String.valueOf(cartouche.getAddressTable())))).withStyle(ChatFormatting.YELLOW));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public abstract ItemLike getItem();

    public abstract Block getBlock();

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(Orientation.getCenterDirection(direction, orientation));
        level.setBlock(blockpos, (BlockState)((BlockState)((BlockState)this.getBlock().defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue(ORIENTATION, (Comparable)((Object)orientation))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity;
        Direction direction = (Direction)state.getValue((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER) {
            pos = pos.relative(Orientation.getMultiDirection(direction, Direction.DOWN, orientation));
        }
        if ((blockentity = level.getBlockEntity(pos)) instanceof CartoucheEntity && !level.isClientSide() && !player.isCreative() && player.hasCorrectToolForDrops(state)) {
            ItemStack itemstack = new ItemStack(this.getItem());
            blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide()) {
            return (localLevel, pos, blockState, entity) -> {
                if (entity instanceof CartoucheEntity) {
                    CartoucheEntity cartouche = (CartoucheEntity)entity;
                    cartouche.tick(localLevel, pos, blockState);
                }
            };
        }
        return null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        boolean hasAddress = false;
        String dimension = "";
        String symbols = "";
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        if (blockEntityTag != null) {
            if (blockEntityTag.contains("address")) {
                hasAddress = true;
                int[] addressArray = blockEntityTag.getIntArray("address");
                Address address = new Address(addressArray);
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.address").append((Component)Component.literal((String)": ").append(address.toComponent(false))).withStyle(ChatFormatting.YELLOW));
            }
            if (blockEntityTag.contains("dimension")) {
                dimension = blockEntityTag.getString("dimension");
            }
            if (blockEntityTag.contains("symbols")) {
                Minecraft minecraft = Minecraft.getInstance();
                ClientPacketListener clientPacketListener = minecraft.getConnection();
                RegistryAccess.Frozen registries = clientPacketListener.registryAccess();
                Registry symbolsRegistry = registries.registryOrThrow(Symbols.REGISTRY_KEY);
                ResourceLocation location = ResourceLocation.parse((String)blockEntityTag.getString("symbols"));
                symbols = location.toString().equals("sgjourney:empty") ? "Empty" : (symbolsRegistry.containsKey(location) ? ((Symbols)symbolsRegistry.get(location)).getTranslationName(!ClientStargateConfig.unique_symbols.get()) : "Error");
            }
            if (blockEntityTag.contains("address_table")) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.address_table").append((Component)Component.literal((String)(": " + blockEntityTag.getString("address_table")))).withStyle(ChatFormatting.YELLOW));
            }
        }
        if (!hasAddress) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.dimension").append((Component)Component.literal((String)(": " + dimension))).withStyle(ChatFormatting.GREEN));
        }
        tooltipComponents.add((Component)Component.translatable((String)Symbols.symbolsOrSet()).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)symbols)).withStyle(ChatFormatting.LIGHT_PURPLE));
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe().contains("generation_step", 1) && StructureGenEntity.Step.SETUP == StructureGenEntity.Step.fromByte(((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe().getByte("generation_step"))) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.generates_inside_structure").withStyle(ChatFormatting.YELLOW));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class RedSandstone
    extends CartoucheBlock {
        public static final MapCodec<RedSandstone> CODEC = RedSandstone.simpleCodec(RedSandstone::new);

        public RedSandstone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected MapCodec<RedSandstone> codec() {
            return CODEC;
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                return null;
            }
            return new CartoucheEntity.RedSandstone(pos, state);
        }

        @Override
        public Block getBlock() {
            return (Block)BlockInit.RED_SANDSTONE_CARTOUCHE.get();
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.RED_SANDSTONE_CARTOUCHE.get();
        }
    }

    public static class Sandstone
    extends CartoucheBlock {
        public static final MapCodec<Sandstone> CODEC = Sandstone.simpleCodec(Sandstone::new);

        public Sandstone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected MapCodec<Sandstone> codec() {
            return CODEC;
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                return null;
            }
            return new CartoucheEntity.Sandstone(pos, state);
        }

        @Override
        public Block getBlock() {
            return (Block)BlockInit.SANDSTONE_CARTOUCHE.get();
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.SANDSTONE_CARTOUCHE.get();
        }
    }

    public static class Stone
    extends CartoucheBlock {
        public static final MapCodec<Stone> CODEC = Stone.simpleCodec(Stone::new);

        public Stone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected MapCodec<Stone> codec() {
            return CODEC;
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                return null;
            }
            return new CartoucheEntity.Stone(pos, state);
        }

        @Override
        public Block getBlock() {
            return (Block)BlockInit.STONE_CARTOUCHE.get();
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.STONE_CARTOUCHE.get();
        }
    }
}

