/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FirePitBlock
extends Block {
    protected final ParticleOptions flameParticle;
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    private static final VoxelShape BOTTOM = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    private static final VoxelShape SIDE_1 = Block.box((double)4.0, (double)1.0, (double)5.0, (double)5.0, (double)2.0, (double)11.0);
    private static final VoxelShape SIDE_2 = Block.box((double)11.0, (double)1.0, (double)5.0, (double)12.0, (double)2.0, (double)11.0);
    private static final VoxelShape SIDE_3 = Block.box((double)5.0, (double)1.0, (double)4.0, (double)11.0, (double)2.0, (double)5.0);
    private static final VoxelShape SIDE_4 = Block.box((double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)2.0, (double)12.0);
    private static final VoxelShape FIRE_PIT = Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{SIDE_1, SIDE_2, SIDE_3, SIDE_4});

    public FirePitBlock(BlockBehaviour.Properties properties, ParticleOptions particle) {
        super(properties);
        this.flameParticle = particle;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue() && player.getItemInHand(hand).getItem() == Items.FLINT_AND_STEEL) {
            level.playSound((Player)null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return ItemInteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue() && player.getItemInHand(hand).getItem() == Items.FIRE_CHARGE) {
            level.playSound((Player)null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                player.getItemInHand(hand).shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{LIT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return FirePitBlock.canSupportCenter((LevelReader)reader, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.3;
        double d2 = (double)pos.getZ() + 0.5;
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            level.addParticle(this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        return FIRE_PIT;
    }
}

