/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.SymbolBlockEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public abstract class SymbolBlock
extends DirectionalBlock
implements EntityBlock {
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.create((String)"orientation", Orientation.class);

    protected SymbolBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(ORIENTATION, (Comparable)((Object)Orientation.REGULAR)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{ORIENTATION});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(ORIENTATION, (Comparable)((Object)Orientation.getOrientationFromXRot(context.getPlayer())));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide()) {
            return (localLevel, pos, blockState, entity) -> {
                if (entity instanceof SymbolBlockEntity) {
                    SymbolBlockEntity symbol = (SymbolBlockEntity)entity;
                    symbol.tick(localLevel, pos, blockState);
                }
            };
        }
        return null;
    }

    public boolean use(Level level, BlockPos pos, Player player) {
        if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof SymbolBlockEntity) {
                MutableComponent text;
                SymbolBlockEntity symbolBlock = (SymbolBlockEntity)blockEntity;
                int symbolNumber = symbolBlock.getSymbolNumber();
                player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.symbol_number").append((Component)Component.literal((String)(": " + symbolNumber))).withStyle(ChatFormatting.YELLOW));
                if (symbolNumber == 0) {
                    MutableComponent pointOfOrigin = Component.literal((String)symbolBlock.getPointOfOrigin().toString());
                    text = Component.translatable((String)"info.sgjourney.point_of_origin").append((Component)Component.literal((String)": ")).append((Component)pointOfOrigin).withStyle(ChatFormatting.DARK_PURPLE);
                } else {
                    MutableComponent symbols = Component.literal((String)symbolBlock.getSymbols().toString());
                    text = Component.translatable((String)"info.sgjourney.symbols").append((Component)Component.literal((String)": ")).append((Component)symbols).withStyle(ChatFormatting.LIGHT_PURPLE);
                }
                player.sendSystemMessage((Component)text);
            }
            return true;
        }
        return false;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(level, pos, player) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.use(level, pos, player) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
    }

    public abstract ItemLike getItem();

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (!level.isClientSide() && !player.isCreative() && player.hasCorrectToolForDrops(state)) {
            ItemStack itemstack = new ItemStack(this.getItem());
            blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        RegistryAccess.Frozen registries = clientPacketListener.registryAccess();
        int symbolNumber = 0;
        String symbol = "";
        String symbols = "";
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        if (blockEntityTag != null) {
            if (blockEntityTag.contains("symbol_number")) {
                symbolNumber = blockEntityTag.getInt("symbol_number");
            }
            if (symbolNumber == 0 && blockEntityTag.contains("symbol")) {
                Registry pointOfOriginRegistry;
                String pointOfOrigin = blockEntityTag.getString("symbol");
                ResourceLocation location = ResourceLocation.tryParse((String)pointOfOrigin);
                symbol = location == null ? "Invalid Path" : ((pointOfOriginRegistry = registries.registryOrThrow(PointOfOrigin.REGISTRY_KEY)).get(ResourceLocation.parse((String)pointOfOrigin)) != null ? ((PointOfOrigin)pointOfOriginRegistry.get(ResourceLocation.parse((String)pointOfOrigin))).getName() : "Error");
            }
            if (symbolNumber != 0 && blockEntityTag.contains("symbols")) {
                Registry symbolsRegistry;
                ResourceLocation location = ResourceLocation.tryParse((String)blockEntityTag.getString("symbols"));
                symbols = location == null ? "Invalid Path" : ((symbolsRegistry = registries.registryOrThrow(Symbols.REGISTRY_KEY)).get(ResourceLocation.parse((String)symbols)) != null ? ((Symbols)symbolsRegistry.get(ResourceLocation.parse((String)symbols))).getName() : "Error");
            }
        }
        if (symbolNumber == 0) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.symbol").append((Component)Component.literal((String)": ").append((Component)Component.translatable((String)symbol))).withStyle(ChatFormatting.DARK_PURPLE));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.symbol_number").append((Component)Component.literal((String)": ").append("" + symbolNumber)).withStyle(ChatFormatting.YELLOW));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.symbols").append((Component)Component.literal((String)": ").append((Component)Component.translatable((String)symbols))).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class RedSandstone
    extends SymbolBlock {
        public static final MapCodec<RedSandstone> CODEC = RedSandstone.simpleCodec(RedSandstone::new);

        public RedSandstone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected MapCodec<RedSandstone> codec() {
            return CODEC;
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new SymbolBlockEntity.RedSandstone(pos, state);
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.RED_SANDSTONE_SYMBOL.get();
        }
    }

    public static class Sandstone
    extends SymbolBlock {
        public static final MapCodec<Sandstone> CODEC = Sandstone.simpleCodec(Sandstone::new);

        public Sandstone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected MapCodec<Sandstone> codec() {
            return CODEC;
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new SymbolBlockEntity.Sandstone(pos, state);
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.SANDSTONE_SYMBOL.get();
        }
    }

    public static class Stone
    extends SymbolBlock {
        public static final MapCodec<Stone> CODEC = Stone.simpleCodec(Stone::new);

        public Stone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected MapCodec<Stone> codec() {
            return CODEC;
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new SymbolBlockEntity.Stone(pos, state);
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.STONE_SYMBOL.get();
        }
    }
}

