/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.dhd;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.MilkyWayDHDEntity;
import net.povstalec.sgjourney.common.blocks.dhd.CrystalDHDBlock;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.menu.MilkyWayDHDMenu;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import net.povstalec.sgjourney.common.misc.NetworkUtils;

public class MilkyWayDHDBlock
extends CrystalDHDBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<MilkyWayDHDBlock> CODEC = MilkyWayDHDBlock.simpleCodec(MilkyWayDHDBlock::new);

    public MilkyWayDHDBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<MilkyWayDHDBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING}).add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MilkyWayDHDEntity(pos, state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public void use(Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MilkyWayDHDEntity) {
            final MilkyWayDHDEntity dhd = (MilkyWayDHDEntity)blockEntity;
            dhd.setStargate();
            if (hitResult.getDirection() != Direction.UP || player.isShiftKeyDown()) {
                this.openCrystalMenu(player, dhd);
            } else {
                MenuProvider containerProvider = new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"screen.sgjourney.dhd");
                    }

                    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new MilkyWayDHDMenu(windowId, playerInventory, dhd);
                    }
                };
                NetworkUtils.openMenu((ServerPlayer)player, containerProvider, dhd.getBlockPos());
            }
        } else {
            throw new IllegalStateException("Our named container provider is missing!");
        }
    }

    @Override
    public Block getDHD() {
        return (Block)BlockInit.MILKY_WAY_DHD.get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return MilkyWayDHDBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.MILKY_WAY_DHD.get(), AbstractDHDEntity::tick);
    }

    public static ItemStack generatedDHD() {
        ItemStack stack = new ItemStack((ItemLike)BlockInit.MILKY_WAY_DHD.get());
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.putString("id", "sgjourney:milky_way_dhd");
        blockEntityTag.putByte("generation_step", StructureGenEntity.Step.SETUP.byteValue());
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
        return stack;
    }

    public static ItemStack milkyWayCrystalSetup() {
        ItemStack stack = new ItemStack((ItemLike)BlockInit.MILKY_WAY_DHD.get());
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.putString("id", "sgjourney:milky_way_dhd");
        blockEntityTag.putLong("energy", 0L);
        CompoundTag crystalInventory = new CompoundTag();
        crystalInventory.putInt("Size", 9);
        crystalInventory.put("Items", (Tag)MilkyWayDHDBlock.setupCrystalInventory());
        blockEntityTag.put("crystal_inventory", (Tag)crystalInventory);
        CompoundTag energyInventory = new CompoundTag();
        energyInventory.putInt("Size", 2);
        energyInventory.put("Items", (Tag)MilkyWayDHDBlock.setupEnergyInventory());
        blockEntityTag.put("energy_inventory", (Tag)energyInventory);
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
        return stack;
    }

    private static ListTag setupEnergyInventory() {
        ListTag nbtTagList = new ListTag();
        nbtTagList.add((Object)InventoryUtil.addItem(0, InventoryUtil.itemName((Item)ItemInit.FUSION_CORE.get()), 1, null));
        return nbtTagList;
    }

    private static ListTag setupCrystalInventory() {
        ListTag nbtTagList = new ListTag();
        nbtTagList.add((Object)InventoryUtil.addItem(0, InventoryUtil.itemName((Item)ItemInit.LARGE_CONTROL_CRYSTAL.get()), 1, null));
        nbtTagList.add((Object)InventoryUtil.addItem(1, InventoryUtil.itemName((Item)ItemInit.ENERGY_CRYSTAL.get()), 1, null));
        nbtTagList.add((Object)InventoryUtil.addItem(2, InventoryUtil.itemName((Item)ItemInit.COMMUNICATION_CRYSTAL.get()), 1, null));
        nbtTagList.add((Object)InventoryUtil.addItem(3, InventoryUtil.itemName((Item)ItemInit.ENERGY_CRYSTAL.get()), 1, null));
        nbtTagList.add((Object)InventoryUtil.addItem(5, InventoryUtil.itemName((Item)ItemInit.ENERGY_CRYSTAL.get()), 1, null));
        nbtTagList.add((Object)InventoryUtil.addItem(7, InventoryUtil.itemName((Item)ItemInit.TRANSFER_CRYSTAL.get()), 1, null));
        return nbtTagList;
    }
}

