/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateRingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class ClassicStargateBaseBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<ClassicStargateBaseBlock> CODEC = ClassicStargateBaseBlock.simpleCodec(ClassicStargateBaseBlock::new);

    public ClassicStargateBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<ClassicStargateBaseBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Direction direction;
            Orientation orientation;
            Address address = new Address();
            if (((Boolean)CommonStargateConfig.enable_address_choice.get()).booleanValue() && stack.is((Item)ItemInit.CONTROL_CRYSTAL.get())) {
                String name = stack.getHoverName().getString();
                address = new Address(name);
                if (address.getLength() != 8) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.classic.invalid_address"), true);
                    return ItemInteractionResult.FAIL;
                }
                if (BlockEntityList.get(level).containsStargate(address.immutable())) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.classic.address_exists"), true);
                    return ItemInteractionResult.FAIL;
                }
            }
            if ((orientation = ClassicStargateBaseBlock.getPlacementOrientation(level, pos, direction = (Direction)level.getBlockState(pos).getValue((Property)FACING))) == null) {
                player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.classic.incorrect_setup"), true);
                return ItemInteractionResult.FAIL;
            }
            ClassicStargateBlock block = (ClassicStargateBlock)BlockInit.CLASSIC_STARGATE.get();
            level.setBlock(pos, (BlockState)((BlockState)block.defaultBlockState().setValue((Property)ClassicStargateBlock.FACING, (Comparable)direction)).setValue((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)orientation)), 3);
            for (StargatePart part : block.getParts()) {
                if (part.equals(StargatePart.BASE)) continue;
                level.setBlock(part.getRingPos(pos, direction, orientation), (BlockState)((BlockState)((BlockState)((ClassicStargateRingBlock)BlockInit.CLASSIC_RING.get()).defaultBlockState().setValue((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).setValue((Property)AbstractStargateRingBlock.FACING, (Comparable)direction)).setValue((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)orientation)), 3);
            }
            BlockEntity baseEntity = level.getBlockEntity(pos);
            if (baseEntity instanceof ClassicStargateEntity) {
                ClassicStargateEntity stargate = (ClassicStargateEntity)baseEntity;
                if (address.getLength() == 8) {
                    stargate.set9ChevronAddress(address);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                }
                stargate.symbolInfo().setPointOfOrigin(PointOfOrigin.randomPointOfOrigin(level.getServer(), (ResourceKey<Level>)level.dimension()));
                stargate.symbolInfo().setSymbols(Symbols.fromDimension(level.getServer(), (ResourceKey<Level>)level.dimension()));
                stargate.displayID();
                stargate.addStargateToNetwork();
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SUCCESS;
    }

    private static Block getClassicStargateBlock(StargatePart part) {
        return switch (part) {
            case StargatePart.LEFT, StargatePart.LEFT3_ABOVE, StargatePart.LEFT3_ABOVE4, StargatePart.LEFT2_ABOVE6, StargatePart.ABOVE6, StargatePart.RIGHT2_ABOVE6, StargatePart.RIGHT3_ABOVE4, StargatePart.RIGHT3_ABOVE, StargatePart.RIGHT -> (Block)BlockInit.CLASSIC_STARGATE_CHEVRON_BLOCK.get();
            default -> (Block)BlockInit.CLASSIC_STARGATE_RING_BLOCK.get();
        };
    }

    private static boolean checkParts(Level level, BlockPos pos, Direction direction, Orientation orientation) {
        ClassicStargateBlock block = (ClassicStargateBlock)BlockInit.CLASSIC_STARGATE.get();
        for (StargatePart part : block.getParts()) {
            if (part.equals(StargatePart.BASE) || level.getBlockState(part.getRingPos(pos, direction, orientation)).is(ClassicStargateBaseBlock.getClassicStargateBlock(part))) continue;
            return false;
        }
        return true;
    }

    private static Orientation getPlacementOrientation(Level level, BlockPos pos, Direction direction) {
        for (Orientation orientation : Orientation.values()) {
            if (!ClassicStargateBaseBlock.checkParts(level, pos, direction, orientation)) continue;
            return orientation;
        }
        return null;
    }
}

