/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class PegasusStargateBlock
extends AbstractStargateBaseBlock {
    public PegasusStargateBlock(BlockBehaviour.Properties properties) {
        super(properties, 7.0, 1.0);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        PegasusStargateEntity stargate = new PegasusStargateEntity(pos, state);
        return stargate;
    }

    @Override
    public AbstractStargateRingBlock getRing() {
        return (AbstractStargateRingBlock)BlockInit.PEGASUS_RING.get();
    }

    @Override
    public AbstractShieldingBlock getIris() {
        return (AbstractShieldingBlock)BlockInit.PEGASUS_SHIELDING.get();
    }

    @Override
    public BlockState ringState() {
        return this.getRing().defaultBlockState();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return null;
        }
        return PegasusStargateBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.PEGASUS_STARGATE.get(), PegasusStargateEntity::tick);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        if (blockEntityTag == null) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.dynamic_symbols").withStyle(ChatFormatting.DARK_AQUA));
        } else if (clientPacketListener != null) {
            RegistryAccess.Frozen registries = clientPacketListener.registryAccess();
            Registry pointOfOriginRegistry = registries.registryOrThrow(PointOfOrigin.REGISTRY_KEY);
            Registry symbolsRegistry = registries.registryOrThrow(Symbols.REGISTRY_KEY);
            if (blockEntityTag.contains("dynamic_symbols") && blockEntityTag.getBoolean("dynamic_symbols")) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.dynamic_symbols").withStyle(ChatFormatting.DARK_AQUA));
            } else {
                String pointOfOrigin = "";
                if (blockEntityTag.contains("point_of_origin")) {
                    ResourceLocation location = ResourceLocation.tryParse((String)blockEntityTag.getString("point_of_origin"));
                    pointOfOrigin = location.equals((Object)StargateJourney.EMPTY_LOCATION) ? "Empty" : (pointOfOriginRegistry.containsKey(location) ? ((PointOfOrigin)pointOfOriginRegistry.get(location)).getName() : "Error");
                }
                String symbols = "";
                if (blockEntityTag.contains("symbols")) {
                    ResourceLocation location = ResourceLocation.tryParse((String)blockEntityTag.getString("symbols"));
                    symbols = location.equals((Object)StargateJourney.EMPTY_LOCATION) ? "Empty" : (symbolsRegistry.containsKey(location) ? ((Symbols)symbolsRegistry.get(location)).getTranslationName(!ClientStargateConfig.unique_symbols.get()) : "Error");
                }
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.point_of_origin").append(": ").append((Component)Component.translatable((String)pointOfOrigin)).withStyle(ChatFormatting.DARK_PURPLE));
                tooltipComponents.add((Component)Component.translatable((String)Symbols.symbolsOrSet()).append(": ").append((Component)Component.translatable((String)symbols)).withStyle(ChatFormatting.LIGHT_PURPLE));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static ItemStack localSymbols(ItemStack stack, BlockEntityType<?> blockEntityType) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putBoolean("dynamic_symbols", false);
        BlockEntity.addEntityType((CompoundTag)compoundtag, blockEntityType);
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundtag));
        return stack;
    }
}

