/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.tech.NaquadahGeneratorEntity;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.menu.NaquadahGeneratorMenu;
import net.povstalec.sgjourney.common.misc.NetworkUtils;

public abstract class NaquadahGeneratorBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;

    public NaquadahGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{ACTIVE}).add(new Property[]{ORIENTATION});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)rotation.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)mirror.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedDirection = context.getClickedFace();
        Direction lookingDirection = clickedDirection.getAxis() == Direction.Axis.Y ? context.getHorizontalDirection().getOpposite() : Direction.UP;
        return (BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)clickedDirection, (Direction)lookingDirection));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (player.isShiftKeyDown()) {
                if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else {
                final BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof NaquadahGeneratorEntity) {
                    MenuProvider containerProvider = new MenuProvider(){

                        public Component getDisplayName() {
                            return Component.translatable((String)"screen.sgjourney.naquadah_generator");
                        }

                        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new NaquadahGeneratorMenu(windowId, playerInventory, blockEntity);
                        }
                    };
                    NetworkUtils.openMenu((ServerPlayer)player, containerProvider, blockEntity.getBlockPos());
                } else {
                    throw new IllegalStateException("Our named container provider is missing!");
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public abstract long energyPerTick();

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)(SGJourneyEnergy.energyToString(this.energyPerTick()) + "/Tick")).withStyle(ChatFormatting.YELLOW));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

