/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech_interface;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.blocks.tech_interface.AbstractInterfaceBlock;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;
import net.povstalec.sgjourney.common.config.CommonInterfaceConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.misc.ComponentHelper;

public class BasicInterfaceBlock
extends AbstractInterfaceBlock {
    public static final MapCodec<BasicInterfaceBlock> CODEC = BasicInterfaceBlock.simpleCodec(BasicInterfaceBlock::new);

    public BasicInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<BasicInterfaceBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BasicInterfaceEntity(pos, state);
    }

    @Override
    public Block getDroppedBlock() {
        return (Block)BlockInit.BASIC_INTERFACE.get();
    }

    @Override
    public long getCapacity() {
        return (Long)CommonInterfaceConfig.basic_interface_capacity.get();
    }

    @Override
    public void updateInterface(BlockState state, Level level, BlockPos pos) {
        if (state.getValue((Property)MODE) == InterfaceMode.SHIELDING) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)AbstractInterfaceBlock.UPDATE, (Comparable)Boolean.valueOf(true))).setValue((Property)MODE, (Comparable)((Object)InterfaceMode.IRIS)), 3);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)AbstractInterfaceBlock.UPDATE, (Comparable)Boolean.valueOf(true)), 3);
        }
        level.scheduleTick(pos, (Block)this, 2);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BasicInterfaceBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.BASIC_INTERFACE.get()), AbstractInterfaceEntity::tick);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)ComponentHelper.description("block.sgjourney.basic_interface.description"));
        tooltipComponents.add((Component)ComponentHelper.usage("block.sgjourney.basic_interface.description.mode"));
    }
}

