/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.transporter;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.common.block_entities.transporter.RingPanelEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.menu.RingPanelMenu;
import net.povstalec.sgjourney.common.misc.NetworkUtils;

public class RingPanelBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected static final VoxelShape NORTH = Block.box((double)2.0, (double)0.0, (double)13.0, (double)14.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0);
    protected static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0);
    protected static final VoxelShape WEST = Block.box((double)13.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    public static final MapCodec<RingPanelBlock> CODEC = RingPanelBlock.simpleCodec(RingPanelBlock::new);

    public RingPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<RingPanelBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RingPanelEntity(pos, state);
    }

    public void use(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide()) {
            final BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RingPanelEntity) {
                RingPanelEntity panel = (RingPanelEntity)blockEntity;
                panel.setTransportRings();
                panel.getNearest6Rings((ServerLevel)level, pos, 32768.0);
                MenuProvider containerProvider = new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"screen.sgjourney.transport_rings");
                    }

                    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new RingPanelMenu(windowId, playerInventory, blockEntity);
                    }
                };
                NetworkUtils.openMenu((ServerPlayer)player, containerProvider, blockEntity.getBlockPos());
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        this.use(level, pos, player);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        this.use(level, pos, player);
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof RingPanelEntity && !level.isClientSide() && !player.isCreative()) {
            ItemStack itemstack = new ItemStack((ItemLike)BlockInit.RING_PANEL.get());
            blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING});
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = reader.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)reader, blockpos, direction);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }
}

