/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.transporter;

import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.povstalec.sgjourney.common.block_entities.transporter.TransportRingsEntity;
import net.povstalec.sgjourney.common.blocks.transporter.AbstractTransporterBlock;
import net.povstalec.sgjourney.common.init.BlockEntityInit;

public class TransportRingsBlock
extends AbstractTransporterBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.VERTICAL);
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");
    public static final MapCodec<TransportRingsBlock> CODEC = TransportRingsBlock.simpleCodec(TransportRingsBlock::new);

    public TransportRingsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<TransportRingsBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING}).add(new Property[]{ACTIVATED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingVerticalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TransportRingsEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TransportRingsBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.TRANSPORT_RINGS.get()), TransportRingsEntity::tick);
    }
}

