/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blockstates;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.povstalec.sgjourney.common.misc.ComponentHelper;

public enum InterfaceMode implements StringRepresentable
{
    OFF("off", (Component)Component.translatable((String)"block.sgjourney.interface.mode.off").withStyle(ChatFormatting.DARK_GRAY), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.off.usage")}),
    RING_SEGMENT("ring_segment", (Component)Component.translatable((String)"block.sgjourney.interface.mode.ring_segment").withStyle(ChatFormatting.GREEN), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.ring_segment.usage"), Component.translatable((String)"tooltip.sgjourney.interface.mode.ring_segment.usage_1").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.ring_segment.usage_2").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.ring_segment.usage_3").withStyle(ChatFormatting.YELLOW)}),
    RING_ROTATION("ring_rotation", (Component)Component.translatable((String)"block.sgjourney.interface.mode.ring_rotation").withStyle(ChatFormatting.DARK_GREEN), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.ring_rotation.usage"), Component.translatable((String)"tooltip.sgjourney.interface.mode.ring_rotation.usage_1").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.ring_rotation.usage_2").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.ring_rotation.usage_3").withStyle(ChatFormatting.YELLOW)}),
    CHEVRONS_ACTIVE("chevrons_active", (Component)Component.translatable((String)"block.sgjourney.interface.mode.chevrons_active").withStyle(ChatFormatting.RED), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.chevrons_active.usage"), Component.translatable((String)"tooltip.sgjourney.interface.mode.chevrons_active.usage_1").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.chevrons_active.usage_2").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.chevrons_active.usage_3").withStyle(ChatFormatting.YELLOW)}),
    WORMHOLE_ACTIVE("wormhole_active", (Component)Component.translatable((String)"block.sgjourney.interface.mode.wormhole_active").withStyle(ChatFormatting.AQUA), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.wormhole_active.usage"), Component.translatable((String)"tooltip.sgjourney.interface.mode.wormhole_active.usage_1").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.wormhole_active.usage_2").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.wormhole_active.usage_3").withStyle(ChatFormatting.YELLOW)}),
    IRIS("iris", (Component)Component.translatable((String)"block.sgjourney.interface.mode.iris").withStyle(ChatFormatting.YELLOW), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.iris.usage.output"), Component.translatable((String)"tooltip.sgjourney.interface.mode.iris.usage.output_1").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.iris.usage.output_2").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.iris.usage.output_3").withStyle(ChatFormatting.YELLOW), ComponentHelper.usage("tooltip.sgjourney.interface.mode.iris.usage.input"), Component.translatable((String)"tooltip.sgjourney.interface.mode.iris.usage.input_1").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"tooltip.sgjourney.interface.mode.iris.usage.input_2").withStyle(ChatFormatting.YELLOW)}),
    SHIELDING("shielding", (Component)Component.translatable((String)"block.sgjourney.interface.mode.shielding").withStyle(ChatFormatting.BLUE), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.shielding.usage")});

    private final String id;
    private final Component name;
    private final Component[] usage;

    private InterfaceMode(String id, Component name, Component ... usage) {
        this.id = id;
        this.name = name;
        this.usage = usage;
    }

    public String getSerializedName() {
        return this.id;
    }

    public Component getName() {
        return this.name;
    }

    public Component[] getUsage() {
        return this.usage;
    }

    public InterfaceMode next(boolean isAdvanced) {
        return switch (this.ordinal()) {
            case 0 -> RING_SEGMENT;
            case 1 -> RING_ROTATION;
            case 2 -> CHEVRONS_ACTIVE;
            case 3 -> WORMHOLE_ACTIVE;
            case 4 -> IRIS;
            case 5 -> {
                if (isAdvanced) {
                    yield SHIELDING;
                }
                yield OFF;
            }
            default -> OFF;
        };
    }

    public InterfaceMode previous(boolean isAdvanced) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (isAdvanced) {
                    yield SHIELDING;
                }
                yield IRIS;
            }
            case 1 -> OFF;
            case 2 -> RING_SEGMENT;
            case 3 -> RING_ROTATION;
            case 4 -> CHEVRONS_ACTIVE;
            case 5 -> WORMHOLE_ACTIVE;
            case 6 -> IRIS;
        };
    }
}

