/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadah;
import net.povstalec.sgjourney.common.entities.Goauld;
import net.povstalec.sgjourney.common.entities.Human;
import net.povstalec.sgjourney.common.entities.goals.EvacuateHostGoal;
import net.povstalec.sgjourney.common.entities.goals.NearestThreatGoal;
import net.povstalec.sgjourney.common.init.AttachmentTypeInit;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.items.GoauldItem;

public class GoauldHost {
    public static final String GOAULD_HOST = "goauld_host";
    public static final EntityCapability<GoauldHost, Void> GOAULD_HOST_CAPABILITY = EntityCapability.createVoid((ResourceLocation)StargateJourney.sgjourneyLocation("goauld_host"), GoauldHost.class);
    public static final String HOST_DATA = "host_data";
    public static final String CUSTOM_NAME = "CustomName";
    private LivingEntity entity;
    private CompoundTag hostData = null;
    private Goauld.Info goauldInfo = null;

    public GoauldHost(LivingEntity entity) {
        this.entity = entity;
        CompoundTag goauldHost = (CompoundTag)this.entity.getData(AttachmentTypeInit.GOAULD_HOST);
        if (goauldHost.contains("goauld_info", 10)) {
            this.goauldInfo = new Goauld.Info();
            this.goauldInfo.deserializeNBT((HolderLookup.Provider)entity.getServer().registryAccess(), goauldHost.getCompound("goauld_info"));
        }
        if (goauldHost.contains(HOST_DATA)) {
            this.hostData = goauldHost.getCompound(HOST_DATA);
        }
    }

    public boolean isHost() {
        return this.goauldInfo != null;
    }

    public boolean takeOverHost(Goauld.Info goauldInfo, Mob host) {
        if (this.goauldInfo != null || goauldInfo == null || host == null) {
            return false;
        }
        this.saveHostData(host);
        GoauldHost.addGoauldHostGoals(host);
        BloodstreamNaquadah cap = (BloodstreamNaquadah)host.getCapability(BloodstreamNaquadah.BLOODSTREAM_NAQUADAH_CAPABILITY);
        if (cap != null) {
            cap.addNaquadahToBloodstream();
        }
        if (goauldInfo.name() != null) {
            host.setCustomName(goauldInfo.name());
        }
        this.goauldInfo = goauldInfo;
        this.update(host.getServer());
        return true;
    }

    public boolean takeOverHost(Goauld goauld, Mob host) {
        if (goauld == null) {
            return false;
        }
        boolean res = this.takeOverHost(goauld.goauldInfo(), host);
        if (res) {
            goauld.remove(Entity.RemovalReason.DISCARDED);
        }
        this.update(goauld.getServer());
        return res;
    }

    public boolean takeOverHost(ItemStack stack, Mob host) {
        if (stack == null || !(stack.getItem() instanceof GoauldItem)) {
            return false;
        }
        return this.takeOverHost(Goauld.Info.fromItemStack(host.getServer(), stack), host);
    }

    public void leaveHost(Mob host) {
        if (host == null || this.goauldInfo == null) {
            return;
        }
        Goauld goauld = (Goauld)EntityInit.GOAULD.get().create(host.level());
        goauld.moveTo(host.getX(), host.getY(), host.getZ(), host.getYRot(), 0.0f);
        goauld.setFromInfo(this.goauldInfo);
        host.level().addFreshEntity((Entity)goauld);
        GoauldHost.removeGoauldHostGoals(host);
        this.restoreHostData(host);
        this.goauldInfo = null;
        this.update(host.getServer());
    }

    public static void addGoauldHostGoals(Mob host) {
        host.targetSelector.addGoal(1, new NearestThreatGoal<Player>(host, Player.class, true));
        host.targetSelector.addGoal(2, new NearestThreatGoal<Human>(host, Human.class, true));
    }

    public static void removeGoauldHostGoals(Mob host) {
        host.goalSelector.removeAllGoals(goal -> goal instanceof EvacuateHostGoal || goal instanceof NearestThreatGoal);
        host.setLastHurtByPlayer(null);
        host.setLastHurtByMob(null);
        host.setTarget(null);
        host.setAggressive(false);
    }

    public void saveHostData(Mob host) {
        this.hostData = new CompoundTag();
        if (host.getCustomName() != null) {
            this.hostData.putString(CUSTOM_NAME, Component.Serializer.toJson((Component)host.getCustomName(), (HolderLookup.Provider)host.getServer().registryAccess()));
        }
    }

    public void restoreHostData(Mob host) {
        if (this.hostData != null) {
            if (this.hostData.contains(CUSTOM_NAME, 8)) {
                host.setCustomName((Component)Component.Serializer.fromJson((String)this.hostData.getString(CUSTOM_NAME), (HolderLookup.Provider)host.getServer().registryAccess()));
            } else {
                host.setCustomName(null);
            }
        }
        this.hostData = null;
    }

    public void copyFrom(GoauldHost source) {
        if (this.goauldInfo != null) {
            this.goauldInfo = source.goauldInfo.copy();
        }
    }

    public void update(MinecraftServer server) {
        CompoundTag goauldHost = new CompoundTag();
        if (this.goauldInfo != null) {
            goauldHost.put("goauld_info", (Tag)this.goauldInfo.serializeNBT((HolderLookup.Provider)server.registryAccess()));
        }
        if (this.hostData != null) {
            goauldHost.put(HOST_DATA, (Tag)this.hostData);
        }
        this.entity.setData(AttachmentTypeInit.GOAULD_HOST, (Object)goauldHost);
    }
}

