/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.InterfaceMethod;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.InterfaceMethods;
import net.povstalec.sgjourney.common.compatibility.computer_functions.InterfaceFunctions;

public class InterfacePeripheral
implements IDynamicPeripheral {
    protected AbstractInterfaceEntity interfaceEntity;
    protected HashMap<String, InterfaceMethod<BlockEntity>> methods = new HashMap();

    public InterfacePeripheral(AbstractInterfaceEntity interfaceEntity) {
        this.interfaceEntity = interfaceEntity;
        this.registerMethod(new InterfaceMethods.SetEnergyTarget());
        this.registerMethod(new InterfaceMethods.AddressToString());
    }

    public String getType() {
        return this.interfaceEntity.getInterfaceType().getName();
    }

    public boolean equals(IPeripheral other) {
        if (this == other) {
            return true;
        }
        return this.getClass() == other.getClass() && this.interfaceEntity == ((InterfacePeripheral)other).interfaceEntity;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.interfaceEntity.getPeripheralWrapper().computerList.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.interfaceEntity.getPeripheralWrapper().computerList.removeIf(computerAccess -> computerAccess.getID() == computer.getID());
    }

    public String[] getMethodNames() {
        return this.methods.keySet().toArray(new String[0]);
    }

    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int method, IArguments arguments) throws LuaException {
        String methodName = this.getMethodNames()[method];
        return this.methods.get(methodName).use(computer, context, this.interfaceEntity, this.interfaceEntity.getEnergyBlockEntity(), arguments);
    }

    public <ConnectedBlockEntity extends BlockEntity> void registerMethod(InterfaceMethod<ConnectedBlockEntity> function) {
        this.methods.put(function.getName(), function);
    }

    @LuaFunction(mainThread=true)
    public final long getEnergy() throws LuaException {
        return InterfaceFunctions.getEnergy(this.interfaceEntity);
    }

    @LuaFunction(mainThread=true)
    public final long getEnergyCapacity() throws LuaException {
        return InterfaceFunctions.getEnergyCapacity(this.interfaceEntity);
    }

    @LuaFunction(mainThread=true)
    public final long getEnergyTarget() throws LuaException {
        return InterfaceFunctions.getEnergyTarget(this.interfaceEntity);
    }
}

