/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.compatibility.jei.AdvancedCrystallizerRecipeCategory;
import net.povstalec.sgjourney.common.compatibility.jei.CrystallizerRecipeCategory;
import net.povstalec.sgjourney.common.compatibility.jei.SGJourneyItemSubtypeInterpreter;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.CrystallizerMenu;
import net.povstalec.sgjourney.common.recipe.AdvancedCrystallizerRecipe;
import net.povstalec.sgjourney.common.recipe.CrystallizerRecipe;

@JeiPlugin
public class SGJourneyJEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_LOCATION = StargateJourney.sgjourneyLocation("jei_plugin");
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 36;
    private static Minecraft minecraft = Minecraft.getInstance();

    public ResourceLocation getPluginUid() {
        return PLUGIN_LOCATION;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CrystallizerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AdvancedCrystallizerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        Item item2;
        Item item1 = BlockInit.CRYSTALLIZER.asItem();
        if (item1 != null) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)item1), new RecipeType[]{CrystallizerRecipeCategory.CRYSTALLIZING_TYPE});
        }
        if ((item2 = BlockInit.ADVANCED_CRYSTALLIZER.asItem()) != null) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)item2), new RecipeType[]{AdvancedCrystallizerRecipeCategory.ADVANCED_CRYSTALLIZING_TYPE});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(SGJourneyJEIPlugin.minecraft.level).getRecipeManager();
        List crystallizerHolders = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)CrystallizerRecipe.Type.CRYSTALLIZING);
        ArrayList<CrystallizerRecipe> crystallizerRecipes = new ArrayList<CrystallizerRecipe>();
        for (RecipeHolder holder : crystallizerHolders) {
            crystallizerRecipes.add((CrystallizerRecipe)holder.value());
        }
        registration.addRecipes(CrystallizerRecipeCategory.CRYSTALLIZING_TYPE, crystallizerRecipes);
        List advancedCrystallizerHolders = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AdvancedCrystallizerRecipe.Type.ADVANCED_CRYSTALLIZING);
        ArrayList<AdvancedCrystallizerRecipe> advancedCrystallizerRecipes = new ArrayList<AdvancedCrystallizerRecipe>();
        for (RecipeHolder holder : advancedCrystallizerHolders) {
            advancedCrystallizerRecipes.add((AdvancedCrystallizerRecipe)holder.value());
        }
        registration.addRecipes(AdvancedCrystallizerRecipeCategory.ADVANCED_CRYSTALLIZING_TYPE, advancedCrystallizerRecipes);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ItemInit.STARGATE_VARIANT_CRYSTAL.get(), (ISubtypeInterpreter)SGJourneyItemSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter((Item)ItemInit.STARGATE_UPGRADE_CRYSTAL.get(), (ISubtypeInterpreter)SGJourneyItemSubtypeInterpreter.INSTANCE);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CrystallizerMenu.class, (MenuType)MenuInit.CRYSTALLIZER.get(), CrystallizerRecipeCategory.CRYSTALLIZING_TYPE, 36, 5, 0, 36);
        registration.addRecipeTransferHandler(CrystallizerMenu.class, (MenuType)MenuInit.CRYSTALLIZER.get(), AdvancedCrystallizerRecipeCategory.ADVANCED_CRYSTALLIZING_TYPE, 36, 5, 0, 36);
    }
}

