/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.sgjourney.common.block_entities.tech.CableBlockEntity;
import net.povstalec.sgjourney.common.config.CommonCableConfig;

public class ConduitNetworks
extends SavedData {
    private static final String FILE_NAME = "sgjourney-conduits";
    public static final String CABLES = "cables";
    private MinecraftServer server;
    protected HashMap<Integer, ConduitNetwork> cableMap = new HashMap();

    private int createCableNetwork() {
        Random random = new Random();
        int id = 0;
        while (id == 0 || this.cableMap.containsKey(id)) {
            id = random.nextInt();
        }
        return id;
    }

    @Nullable
    public ConduitNetwork getCableNetwork(int id) {
        if (id == 0) {
            return null;
        }
        return this.cableMap.get(id);
    }

    public void update(Level level, BlockPos pos) {
        List<CableBlockEntity> cables = ConduitNetworks.findConnectedCables(level, pos);
        if (!cables.isEmpty()) {
            int id = this.createCableNetwork();
            ConduitNetwork newNetwork = new ConduitNetwork(id);
            for (CableBlockEntity cable : cables) {
                this.cableMap.remove(cable.networkID());
                if (cable.isOutput()) {
                    newNetwork.outputs.add(cable.getBlockPos());
                }
                cable.setNetworkID(id);
            }
            if (!newNetwork.outputs.isEmpty()) {
                this.cableMap.put(id, newNetwork);
            }
        }
        this.setDirty();
    }

    public void removeCable(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)blockEntity;
            this.cableMap.remove(cable.networkID());
        }
    }

    public void printConduits() {
        for (Map.Entry<Integer, ConduitNetwork> entry : this.cableMap.entrySet()) {
            System.out.println(String.valueOf(entry.getKey()) + " " + String.valueOf(entry.getValue()));
        }
    }

    private CompoundTag serializeCables(HolderLookup.Provider provider) {
        CompoundTag cables = new CompoundTag();
        this.cableMap.forEach((id, cableNetwork) -> {
            if (!cableNetwork.outputs.isEmpty()) {
                cables.put(id.toString(), (Tag)cableNetwork.serializeNBT(provider));
            }
        });
        return cables;
    }

    public CompoundTag serialize(HolderLookup.Provider provider) {
        CompoundTag conduitNetworks = new CompoundTag();
        CompoundTag cables = this.serializeCables(provider);
        conduitNetworks.put(CABLES, (Tag)cables);
        return conduitNetworks;
    }

    private void deserializeCables(HolderLookup.Provider provider, CompoundTag blockEntityList) {
        CompoundTag cables = blockEntityList.getCompound(CABLES);
        for (String idString : cables.getAllKeys()) {
            int id = Integer.valueOf(idString);
            ConduitNetwork cableNetwork = new ConduitNetwork(id);
            cableNetwork.deserializeNBT(provider, cables.getCompound(idString));
            this.cableMap.put(id, cableNetwork);
        }
    }

    public void deserialize(HolderLookup.Provider provider, CompoundTag tag) {
        this.deserializeCables(provider, tag);
    }

    public ConduitNetworks(MinecraftServer server) {
        this.server = server;
    }

    public static ConduitNetworks create(MinecraftServer server) {
        return new ConduitNetworks(server);
    }

    public static ConduitNetworks load(MinecraftServer server, HolderLookup.Provider provider, CompoundTag tag) {
        ConduitNetworks data = ConduitNetworks.create(server);
        data.server = server;
        data.deserialize(provider, tag);
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag = this.serialize(provider);
        return tag;
    }

    public static SavedData.Factory<ConduitNetworks> dataFactory(MinecraftServer server) {
        return new SavedData.Factory(() -> ConduitNetworks.create(server), (tag, provider) -> ConduitNetworks.load(server, provider, tag));
    }

    @Nonnull
    public static ConduitNetworks get(Level level) {
        if (level.isClientSide()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return ConduitNetworks.get(level.getServer());
    }

    @Nonnull
    public static ConduitNetworks get(MinecraftServer server) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        return (ConduitNetworks)storage.computeIfAbsent(ConduitNetworks.dataFactory(server), FILE_NAME);
    }

    public static List<CableBlockEntity> findConnectedCables(Level level, BlockPos startingPos) {
        Block cableBlock = level.getBlockState(startingPos).getBlock();
        ArrayList<CableBlockEntity> cables = new ArrayList<CableBlockEntity>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startingPos);
        for (int i = 0; !queue.isEmpty() && i < (Integer)CommonCableConfig.max_cables_in_network.get(); ++i) {
            BlockPos pos = (BlockPos)queue.remove();
            visited.add(pos);
            if (level.getBlockState(pos).getBlock() != cableBlock) continue;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CableBlockEntity) {
                CableBlockEntity cable = (CableBlockEntity)blockEntity;
                cables.add(cable);
            }
            for (Direction direction : Direction.values()) {
                BlockPos visitPos = pos.relative(direction);
                if (visited.contains(visitPos)) continue;
                queue.add(visitPos);
            }
        }
        return cables;
    }

    public static class ConduitNetwork
    implements INBTSerializable<CompoundTag> {
        private int id;
        private Set<BlockPos> outputs;

        public ConduitNetwork(int id) {
            this.id = id;
            this.outputs = new HashSet<BlockPos>();
        }

        public long transferEnergy(Level level, long toTransfer, boolean simulate, boolean zeroPointEnergy) {
            if (toTransfer <= 0L || this.outputs.isEmpty()) {
                return 0L;
            }
            int totalOutputs = 0;
            for (BlockPos pos : this.outputs) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof CableBlockEntity)) continue;
                CableBlockEntity cable = (CableBlockEntity)blockEntity;
                totalOutputs += cable.validOutputs();
            }
            if (totalOutputs == 0) {
                return 0L;
            }
            long transferred = 0L;
            long amount = toTransfer / (long)totalOutputs;
            for (BlockPos pos : this.outputs) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof CableBlockEntity)) continue;
                CableBlockEntity cable = (CableBlockEntity)blockEntity;
                for (Direction direction : cable.getConnectedSides()) {
                    transferred += cable.outputEnergy(direction, amount, simulate, zeroPointEnergy);
                }
            }
            return transferred;
        }

        public String toString() {
            return this.outputs.toString();
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            int i = 0;
            for (BlockPos pos : this.outputs) {
                tag.putIntArray(String.valueOf(i), new int[]{pos.getX(), pos.getY(), pos.getZ()});
                ++i;
            }
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            for (String key : tag.getAllKeys()) {
                int[] xyz = tag.getIntArray(key);
                this.outputs.add(new BlockPos(xyz[0], xyz[1], xyz[2]));
            }
        }
    }
}

