/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.TransporterConnection;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public final class TransporterNetwork
extends SavedData {
    private static final String FILE_NAME = "sgjourney-transporter_network";
    private static final String DIMENSIONS = "dimensions";
    private static final String CONNECTIONS = "connections";
    private static final String VERSION = "version";
    private static final int UPDATE_VERSION = 2;
    private MinecraftServer server;
    private Map<String, Dimension> dimensions = new HashMap<String, Dimension>();
    private HashMap<UUID, TransporterConnection> connections = new HashMap();
    private int version = 0;

    public int getVersion() {
        return this.version;
    }

    private void updateVersion() {
        this.version = 2;
    }

    public void updateNetwork(MinecraftServer server) {
        if (this.getVersion() == 2) {
            StargateJourney.LOGGER.info("Transporter Network is up to date (Version: " + this.version + ")");
            return;
        }
        StargateJourney.LOGGER.info("Detected an incompatible Transporter Network version (Version: " + this.getVersion() + ") - updating to version 2");
        this.reloadNetwork(server, false);
    }

    public void reloadNetwork(MinecraftServer server, boolean updateInterfaces) {
        this.eraseNetwork();
        StargateJourney.LOGGER.info("Transporter Network erased");
        this.addTransporters();
        StargateJourney.LOGGER.info("Transporters added");
        this.updateVersion();
        StargateJourney.LOGGER.info("Version updated");
        this.setDirty();
    }

    public void eraseNetwork() {
        this.dimensions.clear();
        this.setDirty();
    }

    private void addTransporters() {
        HashMap<UUID, Transporter> transporters = BlockEntityList.get(this.server).getTransporters();
        transporters.entrySet().stream().forEach(transporterInfo -> {
            Transporter transporter = (Transporter)transporterInfo.getValue();
            BlockEntity blockentity = this.server.getLevel(transporter.getDimension()).getBlockEntity(transporter.getBlockPos());
            if (blockentity instanceof AbstractTransporterEntity) {
                AbstractTransporterEntity transporterEntity = (AbstractTransporterEntity)blockentity;
                if (transporterEntity.getID() != null && transporterEntity.getID().equals(transporter.getID())) {
                    this.addTransporterToDimension(transporter.getDimension(), transporter);
                } else {
                    BlockEntityList.get(this.server).removeTransporter(transporter.getID());
                    this.addTransporter(transporterEntity);
                }
            } else {
                BlockEntityList.get(this.server).removeTransporter(transporter.getID());
            }
        });
    }

    public void addTransporter(Transporter transporter) {
        if (transporter != null) {
            this.addTransporterToDimension(transporter.getDimension(), transporter);
        }
        this.setDirty();
    }

    public void addTransporter(AbstractTransporterEntity transporterEntity) {
        Transporter transporter = BlockEntityList.get(this.server).addTransporter(transporterEntity);
        if (transporter != null && transporterEntity.getID() != null && transporterEntity.getID().equals(transporter.getID())) {
            this.addTransporter(transporter);
        }
    }

    public void removeTransporter(Level level, UUID uuid) {
        if (uuid == null) {
            return;
        }
        Transporter transporter = this.getTransporter(uuid);
        if (transporter != null) {
            this.removeTransporterFromDimension((ResourceKey<Level>)level.dimension(), transporter);
        }
        BlockEntityList.get(level).removeTransporter(uuid);
        StargateJourney.LOGGER.info("Removed " + uuid.toString() + " from Transporter Network");
        this.setDirty();
    }

    @Nullable
    public Transporter getTransporter(UUID uuid) {
        return BlockEntityList.get(this.server).getTransporter(uuid);
    }

    public void addTransporterToDimension(ResourceKey<Level> dimensionKey, Transporter transporter) {
        String dimensionString = dimensionKey.location().toString();
        if (!this.dimensions.containsKey(dimensionString)) {
            this.dimensions.put(dimensionString, new Dimension(dimensionKey));
        }
        this.dimensions.get(dimensionString).addTransporter(transporter);
    }

    public void removeTransporterFromDimension(ResourceKey<Level> dimensionKey, Transporter transporter) {
        String dimensionString = dimensionKey.location().toString();
        if (this.dimensions.containsKey(dimensionString)) {
            this.dimensions.get(dimensionString).removeTransporter(transporter);
        }
    }

    public List<Transporter> getTransportersFromDimension(ResourceKey<Level> dimensionKey) {
        Dimension dimension;
        if (this.dimensions.containsKey(dimensionKey.location().toString()) && (dimension = this.dimensions.get(dimensionKey.location().toString())) != null) {
            return dimension.getTransporters();
        }
        return ImmutableList.of();
    }

    public final void printDimensions() {
        System.out.println("[Dimensions - Transporters]");
        this.dimensions.entrySet().stream().forEach(dimensionEntry -> ((Dimension)dimensionEntry.getValue()).printDimension());
    }

    public void handleConnections() {
        HashMap<UUID, TransporterConnection> connections = new HashMap<UUID, TransporterConnection>();
        connections.putAll(this.connections);
        connections.forEach((uuid, connection) -> connection.tick(this.server));
        this.setDirty();
    }

    public boolean createConnection(MinecraftServer server, Transporter transporterA, Transporter transporterB) {
        TransporterConnection connection = TransporterConnection.create(server, transporterA, transporterB);
        if (connection == null) {
            return false;
        }
        return this.addConnection(connection);
    }

    public boolean addConnection(TransporterConnection connection) {
        if (this.hasConnection(connection.getID())) {
            return false;
        }
        this.connections.put(connection.getID(), connection);
        return true;
    }

    public boolean hasConnection(UUID uuid) {
        return this.connections.containsKey(uuid);
    }

    public void terminateConnection(UUID uuid) {
        TransporterConnection connection = this.connections.get(uuid);
        if (connection == null) {
            return;
        }
        connection.terminate(this.server);
    }

    public void removeConnection(UUID uuid) {
        if (this.hasConnection(uuid)) {
            this.connections.remove(uuid);
            StargateJourney.LOGGER.debug("Removed connection " + String.valueOf(uuid));
        } else {
            StargateJourney.LOGGER.error("Could not find connection " + String.valueOf(uuid));
        }
        this.setDirty();
    }

    private CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putInt(VERSION, this.version);
        tag.put(DIMENSIONS, (Tag)this.serializeDimensions());
        tag.put(CONNECTIONS, (Tag)this.serializeConnections());
        return tag;
    }

    private CompoundTag serializeDimensions() {
        CompoundTag dimensionsTag = new CompoundTag();
        this.dimensions.forEach((dimensionString, dimension) -> dimensionsTag.put(dimensionString, (Tag)dimension.serialize()));
        return dimensionsTag;
    }

    private CompoundTag serializeConnections() {
        CompoundTag connectionsTag = new CompoundTag();
        this.connections.forEach((connectionID, connection) -> connectionsTag.put(connectionID.toString(), (Tag)connection.serialize()));
        return connectionsTag;
    }

    private void deserialize(CompoundTag tag) {
        this.version = tag.getInt(VERSION);
        this.deserializeDimensions(tag.getCompound(DIMENSIONS));
        this.deserializeConnections(tag.getCompound(CONNECTIONS));
    }

    private void deserializeDimensions(CompoundTag tag) {
        tag.getAllKeys().forEach(dimensionString -> this.dimensions.put((String)dimensionString, Dimension.deserialize(this.server, tag.getCompound(dimensionString))));
    }

    private void deserializeConnections(CompoundTag tag) {
        for (String connectionID : tag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(connectionID);
                TransporterConnection connection = TransporterConnection.deserialize(this.server, UUID.fromString(connectionID), tag.getCompound(connectionID));
                if (connection == null) continue;
                this.connections.put(uuid, connection);
            }
            catch (IllegalArgumentException e) {
                StargateJourney.LOGGER.error(e.toString());
            }
        }
    }

    public TransporterNetwork(MinecraftServer server) {
        this.server = server;
    }

    public static TransporterNetwork create(MinecraftServer server) {
        return new TransporterNetwork(server);
    }

    public static TransporterNetwork load(MinecraftServer server, CompoundTag tag) {
        TransporterNetwork data = TransporterNetwork.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag = this.serialize();
        return tag;
    }

    public static SavedData.Factory<TransporterNetwork> dataFactory(MinecraftServer server) {
        return new SavedData.Factory(() -> TransporterNetwork.create(server), (tag, provider) -> TransporterNetwork.load(server, tag));
    }

    @Nonnull
    public static TransporterNetwork get(Level level) {
        if (level.isClientSide()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return TransporterNetwork.get(level.getServer());
    }

    @Nonnull
    public static TransporterNetwork get(MinecraftServer server) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        return (TransporterNetwork)storage.computeIfAbsent(TransporterNetwork.dataFactory(server), FILE_NAME);
    }

    private static class Dimension {
        private static final String DIMENSION = "Dimension";
        private static final String TRANSPORTERS = "Transporters";
        private final ResourceKey<Level> dimension;
        private List<Transporter> transporters = new ArrayList<Transporter>();

        private Dimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
        }

        private Dimension(ResourceKey<Level> dimension, List<Transporter> transporters) {
            this.dimension = dimension;
            this.transporters = transporters;
        }

        public void addTransporter(Transporter transporter) {
            if (this.transporters.contains(transporter)) {
                return;
            }
            this.transporters.add(transporter);
        }

        public void removeTransporter(Transporter transporter) {
            if (this.transporters.contains(transporter)) {
                this.transporters.remove(transporter);
            }
        }

        public List<Transporter> getTransporters() {
            return new ArrayList<Transporter>(this.transporters);
        }

        public void printDimension() {
            System.out.println("- [" + this.dimension.location().toString() + "]");
            this.transporters.stream().forEach(transporter -> System.out.println("--- " + transporter.toString()));
        }

        public CompoundTag serialize() {
            CompoundTag dimensionTag = new CompoundTag();
            dimensionTag.putString(DIMENSION, this.dimension.location().toString());
            CompoundTag transportersTag = new CompoundTag();
            this.transporters.stream().forEach(transporter -> transportersTag.putString(transporter.getID().toString(), transporter.getID().toString()));
            dimensionTag.put(TRANSPORTERS, (Tag)transportersTag);
            return dimensionTag;
        }

        public static Dimension deserialize(MinecraftServer server, CompoundTag dimensionTag) {
            ResourceKey<Level> dimension = Conversion.stringToDimension(dimensionTag.getString(DIMENSION));
            ArrayList<Transporter> transporters = new ArrayList<Transporter>();
            dimensionTag.getCompound(TRANSPORTERS).getAllKeys().forEach(transporterID -> {
                Transporter transporter = BlockEntityList.get(server).getTransporter(UUID.fromString(transporterID));
                if (transporter != null) {
                    transporters.add(transporter);
                }
            });
            return new Dimension(dimension, transporters);
        }
    }
}

