/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.Symbols;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class Universe
extends SavedData {
    private static final ResourceLocation MILKY_WAY = StargateJourney.sgjourneyLocation("milky_way");
    private static final String FILE_NAME = "sgjourney-universe";
    private static final String DIMENSIONS = "dimensions";
    private static final String SOLAR_SYSTEMS = "solar_systems";
    private static final String GALAXIES = "galaxies";
    private static final String NUMBERS_AND_LETTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private MinecraftServer server;
    private HashMap<Address.Immutable, SolarSystem.Serializable> solarSystems = new HashMap();
    private HashMap<ResourceLocation, SolarSystem.Serializable> solarSystemLocations = new HashMap();
    private HashMap<ResourceKey<Level>, SolarSystem.Serializable> dimensions = new HashMap();
    private HashMap<ResourceLocation, Galaxy.Serializable> galaxies = new HashMap();

    public void generateUniverseInfo(MinecraftServer server) {
        this.registerGalaxies(server);
        this.registerPointsOfOrigin(server);
        this.registerSolarSystemsFromDataPacks(server);
        if (this.generateRandomSolarSystems(server)) {
            this.generateAndRegisterSolarSystems(server);
        }
        this.setDirty();
    }

    public void eraseUniverseInfo() {
        this.galaxies.clear();
        this.dimensions.clear();
        this.solarSystems.clear();
        this.solarSystemLocations.clear();
        this.setDirty();
    }

    private boolean useDatapackAddresses(MinecraftServer server) {
        return StargateNetworkSettings.get(server).useDatapackAddresses();
    }

    private boolean generateRandomSolarSystems(MinecraftServer server) {
        return StargateNetworkSettings.get(server).generateRandomSolarSystems();
    }

    private boolean randomAddressFromSeed(MinecraftServer server) {
        return StargateNetworkSettings.get(server).randomAddressFromSeed();
    }

    private void registerGalaxies(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.registryAccess();
        Registry galaxyRegistry = registries.registryOrThrow(Galaxy.REGISTRY_KEY);
        Set galaxySet = galaxyRegistry.entrySet();
        galaxySet.forEach(galaxyEntry -> {
            ResourceKey galaxyKey = (ResourceKey)galaxyEntry.getKey();
            Galaxy.Serializable galaxy = new Galaxy.Serializable((ResourceKey<Galaxy>)galaxyKey, (Galaxy)galaxyEntry.getValue(), new HashMap<Address.Immutable, SolarSystem.Serializable>(), new ArrayList<ResourceKey<PointOfOrigin>>());
            this.galaxies.put(((ResourceKey)galaxyEntry.getKey()).location(), galaxy);
        });
        StargateJourney.LOGGER.info("Galaxies registered");
    }

    private void registerPointsOfOrigin(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.registryAccess();
        Registry pointOfOriginRegistry = registries.registryOrThrow(PointOfOrigin.REGISTRY_KEY);
        Set pointOfOriginSet = pointOfOriginRegistry.entrySet();
        pointOfOriginSet.forEach(pointOfOriginEntry -> {
            PointOfOrigin pointOfOrigin = (PointOfOrigin)pointOfOriginEntry.getValue();
            ResourceKey pointOfOriginKey = (ResourceKey)pointOfOriginEntry.getKey();
            Optional<List<ResourceKey<Galaxy>>> galaxiesOptional = pointOfOrigin.generatedGalaxies();
            if (galaxiesOptional.isPresent()) {
                galaxiesOptional.get().stream().forEach(galaxyKey -> {
                    Galaxy.Serializable galaxy = this.galaxies.get(galaxyKey.location());
                    if (galaxy != null) {
                        galaxy.addPointOfOrigin((ResourceKey<PointOfOrigin>)pointOfOriginKey);
                    }
                });
            }
        });
    }

    public ResourceKey<PointOfOrigin> getRandomPointOfOriginFromDimension(ResourceKey<Level> dimension, long seed) {
        Galaxy.Serializable galaxy = this.getGalaxyFromDimension(dimension);
        if (galaxy != null) {
            return galaxy.getRandomPointOfOrigin(seed);
        }
        return PointOfOrigin.defaultPointOfOrigin();
    }

    private void registerSolarSystemsFromDataPacks(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.registryAccess();
        Registry solarSystemRegistry = registries.registryOrThrow(SolarSystem.REGISTRY_KEY);
        Set solarSystemSet = solarSystemRegistry.entrySet();
        solarSystemSet.forEach(solarSystem -> this.addSolarSystemFromDataPack(server, (ResourceKey<SolarSystem>)((ResourceKey)solarSystem.getKey()), (SolarSystem)solarSystem.getValue()));
        StargateJourney.LOGGER.info("Datapack Solar Systems registered");
    }

    private void generateAndRegisterSolarSystems(MinecraftServer server) {
        Set levelSet = server.levelKeys();
        levelSet.forEach(dimension -> {
            if (!this.dimensions.containsKey(dimension)) {
                this.generateNewSolarSystem(server, (ResourceKey<Level>)dimension);
            }
        });
        StargateJourney.LOGGER.info("Solar Systems generated");
    }

    private void addSolarSystemFromDataPack(MinecraftServer server, ResourceKey<SolarSystem> solarSystemKey, SolarSystem solarSystem) {
        Address.Immutable extragalacticAddress;
        if (this.useDatapackAddresses(server)) {
            extragalacticAddress = new Address(solarSystem.getAddressArray()).immutable();
        } else {
            int prefix = solarSystem.getSymbolPrefix();
            long seed = this.generateRandomAddressSeed(server, solarSystemKey.location().toString());
            extragalacticAddress = this.generateExtragalacticAddress(prefix <= 0 ? 1 : prefix, seed);
        }
        SolarSystem.Serializable networkSolarSystem = new SolarSystem.Serializable(solarSystemKey.location(), extragalacticAddress, solarSystem);
        if (this.saveSolarSystem(extragalacticAddress, networkSolarSystem) && solarSystem.getAddresses().isPresent()) {
            solarSystem.getAddresses().get().stream().forEach(galaxyAndAddress -> {
                ResourceKey galaxyKey = (ResourceKey)galaxyAndAddress.getFirst();
                Galaxy.Serializable galaxy = this.galaxies.get(galaxyKey.location());
                if (galaxy != null) {
                    Address.Immutable address;
                    Pair randomizableAddress = (Pair)galaxyAndAddress.getSecond();
                    boolean isRandomizable = (Boolean)randomizableAddress.getSecond();
                    if (!this.useDatapackAddresses(server) && isRandomizable) {
                        long systemValue = this.generateRandomAddressSeed(server, solarSystemKey.location().toString());
                        address = this.generateAddress(galaxyKey.location(), galaxy.getSize(), systemValue);
                    } else {
                        address = new Address(Address.integerListToArray((List)randomizableAddress.getFirst())).immutable();
                    }
                    galaxy.addSolarSystem(address, networkSolarSystem);
                    networkSolarSystem.addToGalaxy(galaxy, address);
                }
            });
        }
    }

    private void generateNewSolarSystem(MinecraftServer server, ResourceKey<Level> dimension) {
        RegistryAccess.Frozen registries = server.registryAccess();
        Registry galaxyRegistry = registries.registryOrThrow(Galaxy.REGISTRY_KEY);
        Galaxy defaultGalaxy = (Galaxy)galaxyRegistry.get(MILKY_WAY);
        ResourceKey<Symbols> defaultSymbols = defaultGalaxy.getDefaultSymbols();
        String dimensionName = dimension.location().toString();
        long seed = this.generateRandomAddressSeed(server, dimensionName);
        String systemName = this.generateSolarSystemName(seed);
        int milkyWayPrefix = 1;
        Address.Immutable extragalacticAddress = this.generateExtragalacticAddress(milkyWayPrefix, seed);
        ResourceLocation galaxyID = StargateJourney.sgjourneyLocation("milky_way");
        Galaxy.Serializable galaxy = this.galaxies.get(galaxyID);
        ResourceKey<PointOfOrigin> pointOfOrigin = galaxy != null ? galaxy.getRandomPointOfOrigin(seed) : PointOfOrigin.defaultPointOfOrigin();
        SolarSystem.Serializable solarSystem = new SolarSystem.Serializable(this.systemNameToResourceLocation(systemName), systemName, extragalacticAddress, pointOfOrigin, defaultSymbols, milkyWayPrefix, List.of(dimension));
        if (this.saveSolarSystem(extragalacticAddress, solarSystem)) {
            long systemValue = this.generateRandomAddressSeed(server, solarSystem.getName());
            Address.Immutable address = this.generateAddress(galaxyID, defaultGalaxy.getType().getSize(), systemValue);
            if (galaxy != null) {
                galaxy.addSolarSystem(address, solarSystem);
                solarSystem.addToGalaxy(galaxy, address);
            }
        }
    }

    private String generateSolarSystemName(long seed) {
        int maxRandom = NUMBERS_AND_LETTERS.length();
        Random random = new Random(seed);
        int prefixAValue = random.nextInt(0, maxRandom);
        int prefixBValue = random.nextInt(0, maxRandom);
        char prefixA = NUMBERS_AND_LETTERS.charAt(prefixAValue);
        char prefixB = NUMBERS_AND_LETTERS.charAt(prefixBValue);
        int suffixValue = random.nextInt(1, 10000);
        String systemName = "P" + prefixA + prefixB + "-" + suffixValue;
        return systemName;
    }

    private ResourceLocation systemNameToResourceLocation(String systemName) {
        return StargateJourney.sgjourneyLocation(systemName.toLowerCase());
    }

    private long generateRandomAddressSeed(MinecraftServer server, String name) {
        long seed = this.randomAddressFromSeed(server) ? server.getWorldData().worldGenOptions().seed() : 0L;
        for (int i = 0; i < name.length(); ++i) {
            seed += (long)Character.valueOf(name.charAt(i)).charValue();
        }
        return seed;
    }

    private Address.Immutable generateExtragalacticAddress(int prefix, long seed) {
        Address.Immutable extragalacticAddress;
        int i = 0;
        while (this.solarSystems.containsKey(extragalacticAddress = new Address().randomAddress(prefix, 7, 36, seed += (long)i).immutable())) {
            ++i;
        }
        return extragalacticAddress;
    }

    private boolean saveSolarSystem(Address.Immutable extragalacticAddress, SolarSystem.Serializable solarSystem) {
        String solarSystemName = solarSystem.getName();
        if (this.solarSystems.containsKey(extragalacticAddress)) {
            StargateJourney.LOGGER.info("Failed to save Solar System " + solarSystemName + " as it is already saved in the Stargate Network");
            return false;
        }
        this.solarSystems.put(extragalacticAddress, solarSystem);
        this.solarSystemLocations.put(solarSystem.location(), solarSystem);
        solarSystem.getDimensions().forEach(dimension -> this.dimensions.put((ResourceKey<Level>)dimension, solarSystem));
        String pointOfOrigin = solarSystem.getPointOfOrigin().location().toString();
        String symbols = solarSystem.getSymbols().location().toString();
        StargateJourney.LOGGER.info("Saved Solar System: " + solarSystemName + "[PoO: " + pointOfOrigin + " Symbols: " + symbols + "]");
        return true;
    }

    private Address.Immutable generateAddress(ResourceLocation galaxyID, int galaxySize, long seed) {
        Address.Immutable address;
        int i = 0;
        while (true) {
            address = new Address().randomAddress(6, galaxySize, seed += (long)i).immutable();
            if (!this.galaxies.get(galaxyID).containsSolarSystem(address)) break;
            ++i;
        }
        return address;
    }

    public void addStargateToDimension(ResourceKey<Level> dimension, Stargate stargate) {
        SolarSystem.Serializable solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem != null) {
            solarSystem.addStargate(this.server, stargate);
            this.setDirty();
        }
    }

    public void removeStargateFromSolarSystem(SolarSystem.Serializable solarSystem, Stargate stargate) {
        if (solarSystem != null) {
            solarSystem.removeStargate(stargate);
            this.setDirty();
        }
    }

    public void removeStargateFromDimension(ResourceKey<Level> dimension, Stargate stargate) {
        SolarSystem.Serializable solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem != null) {
            this.removeStargateFromSolarSystem(solarSystem, stargate);
        }
    }

    public void printDimensions() {
        System.out.println("[Dimensions - Solar Systems]");
        this.dimensions.entrySet().stream().forEach(dimensionEntry -> System.out.println("- |" + ((ResourceKey)dimensionEntry.getKey()).location().toString() + "| = |" + ((SolarSystem.Serializable)dimensionEntry.getValue()).getName() + "|"));
    }

    public void printSolarSystems() {
        System.out.println("[Solar Systems]");
        this.solarSystems.entrySet().stream().forEach(solarSystemEntry -> {
            SolarSystem.Serializable solarSystem = (SolarSystem.Serializable)solarSystemEntry.getValue();
            System.out.println("- [Generated: " + solarSystem.isGenerated() + "] " + ((Address.Immutable)solarSystemEntry.getKey()).toString() + " " + solarSystem.getName());
            solarSystem.getStargates().stream().forEach(stargate -> System.out.println("--- " + stargate.toString()));
        });
    }

    public void printGalaxies() {
        System.out.println("[Galaxies]");
        this.galaxies.entrySet().stream().forEach(galaxyEntry -> {
            Galaxy.Serializable galaxy = (Galaxy.Serializable)galaxyEntry.getValue();
            System.out.println("- " + ((ResourceLocation)galaxyEntry.getKey()).toString());
            galaxy.printSolarSystems();
        });
    }

    @Nullable
    public SolarSystem.Serializable getSolarSystemFromDimension(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return null;
        }
        return this.dimensions.get(dimension);
    }

    @Nullable
    public SolarSystem.Serializable getSolarSystemFromExtragalacticAddress(Address.Immutable extragalacticAddress) {
        return this.solarSystems.get(extragalacticAddress);
    }

    public List<ResourceKey<Level>> getDimensionsWithGeneratedSolarSystems() {
        ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
        this.dimensions.entrySet().forEach(dimensionEntry -> {
            if (((SolarSystem.Serializable)dimensionEntry.getValue()).isGenerated()) {
                dimensions.add((ResourceKey)dimensionEntry.getKey());
            }
        });
        return dimensions;
    }

    @Nullable
    public List<ResourceKey<Level>> getDimensionsFromSolarSystem(Address.Immutable extragalacticAddress) {
        SolarSystem.Serializable solarSystem = this.getSolarSystemFromExtragalacticAddress(extragalacticAddress);
        if (solarSystem != null) {
            return solarSystem.getDimensions();
        }
        return new ArrayList<ResourceKey<Level>>();
    }

    @Nullable
    public SolarSystem.Serializable getSolarSystemInGalaxy(ResourceLocation galaxyID, Address.Immutable address) {
        if (!this.galaxies.containsKey(galaxyID)) {
            return null;
        }
        return this.galaxies.get(galaxyID).getSolarSystem(address);
    }

    @Nullable
    public SolarSystem.Serializable getSolarSystemFromAddress(SolarSystem.Serializable solarSystem, Address.Immutable address) {
        if (solarSystem != null) {
            return solarSystem.getSolarSystemFromAddress(address);
        }
        return null;
    }

    @Nullable
    public HashMap<Galaxy.Serializable, Address.Immutable> getGalaxiesFromDimension(ResourceKey<Level> dimension) {
        SolarSystem.Serializable solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem != null) {
            return solarSystem.getGalacticAddresses();
        }
        return null;
    }

    @Nullable
    public Galaxy.Serializable getGalaxy(ResourceLocation galaxyID) {
        return this.galaxies.get(galaxyID);
    }

    @Nullable
    public Galaxy.Serializable getGalaxyFromDimension(ResourceKey<Level> dimension) {
        HashMap<Galaxy.Serializable, Address.Immutable> galaxies = this.getGalaxiesFromDimension(dimension);
        if (galaxies != null && !galaxies.isEmpty()) {
            return galaxies.entrySet().iterator().next().getKey();
        }
        return null;
    }

    @Nullable
    public Address.Immutable getAddressInGalaxyFromSolarSystem(ResourceLocation galaxyID, SolarSystem.Serializable solarSystem) {
        if (this.galaxies.containsKey(galaxyID) && solarSystem != null) {
            Galaxy.Serializable galaxy = this.galaxies.get(galaxyID);
            return solarSystem.getAddressFromGalaxy(galaxy);
        }
        return null;
    }

    @Nullable
    public Address.Immutable getAddressInGalaxyFromDimension(ResourceLocation galaxyID, ResourceKey<Level> dimension) {
        SolarSystem.Serializable solarSystem = this.getSolarSystemFromDimension(dimension);
        return this.getAddressInGalaxyFromSolarSystem(galaxyID, solarSystem);
    }

    @Nullable
    public Address.Immutable getExtragalacticAddressFromDimension(ResourceKey<Level> dimension) {
        SolarSystem.Serializable solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem != null) {
            return solarSystem.getExtragalacticAddress();
        }
        return null;
    }

    public ResourceKey<PointOfOrigin> getPointOfOrigin(ResourceKey<Level> dimension) {
        SolarSystem.Serializable solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem != null) {
            return solarSystem.getPointOfOrigin();
        }
        return PointOfOrigin.defaultPointOfOrigin();
    }

    public ResourceKey<Symbols> getSymbols(ResourceKey<Level> dimension) {
        SolarSystem.Serializable solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem != null) {
            return solarSystem.getSymbols();
        }
        return Symbols.defaultSymbols();
    }

    public HashMap<ResourceLocation, Address.Immutable> getPrimaryStargateAddresses() {
        HashMap<ResourceLocation, Address.Immutable> primaryStargates = new HashMap<ResourceLocation, Address.Immutable>();
        for (Map.Entry<Address.Immutable, SolarSystem.Serializable> entry : this.solarSystems.entrySet()) {
            Address.Immutable address = entry.getValue().primaryAddress();
            if (address == null) continue;
            primaryStargates.put(entry.getValue().location(), address);
        }
        return primaryStargates;
    }

    public void setPrimaryStargateAddresses(HashMap<ResourceLocation, Address.Immutable> primaryStargates) {
        for (Map.Entry<ResourceLocation, Address.Immutable> entry : primaryStargates.entrySet()) {
            SolarSystem.Serializable solarSystem = this.solarSystemLocations.get(entry.getKey());
            if (solarSystem == null) continue;
            solarSystem.setPrimaryStargate(entry.getValue());
        }
    }

    private CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.put(SOLAR_SYSTEMS, (Tag)this.serializeSolarSystems());
        tag.put(DIMENSIONS, (Tag)this.serializeDimensions());
        tag.put(GALAXIES, (Tag)this.serializeGalaxies());
        return tag;
    }

    private CompoundTag serializeDimensions() {
        CompoundTag dimensionsTag = new CompoundTag();
        this.dimensions.forEach((dimension, solarSystem) -> dimensionsTag.putIntArray(dimension.location().toString(), solarSystem.getExtragalacticAddress().toArray()));
        return dimensionsTag;
    }

    private CompoundTag serializeSolarSystems() {
        CompoundTag solarSystemsTag = new CompoundTag();
        this.solarSystems.forEach((extragalacticAddress, solarSystem) -> solarSystemsTag.put(extragalacticAddress.toString(), (Tag)solarSystem.serialize()));
        return solarSystemsTag;
    }

    private CompoundTag serializeGalaxies() {
        CompoundTag galaxiesTag = new CompoundTag();
        this.galaxies.forEach((galaxyID, galaxy) -> galaxiesTag.put(galaxyID.toString(), (Tag)galaxy.serialize()));
        return galaxiesTag;
    }

    private void deserialize(MinecraftServer server, CompoundTag tag) {
        this.deserializeSolarSystems(tag.getCompound(SOLAR_SYSTEMS));
        this.deserializeDimensions(tag.getCompound(DIMENSIONS));
        this.deserializeGalaxies(server, tag.getCompound(GALAXIES));
    }

    private void deserializeSolarSystems(CompoundTag tag) {
        RegistryAccess.Frozen registries = this.server.registryAccess();
        Registry solarSystemRegistry = registries.registryOrThrow(SolarSystem.REGISTRY_KEY);
        tag.getAllKeys().forEach(solarSystemString -> {
            SolarSystem.Serializable solarSystem = SolarSystem.Serializable.deserialize(this.server, (Registry<SolarSystem>)solarSystemRegistry, tag.getCompound(solarSystemString));
            this.solarSystems.put(solarSystem.getExtragalacticAddress(), solarSystem);
        });
    }

    private void deserializeDimensions(CompoundTag tag) {
        tag.getAllKeys().forEach(dimensionString -> {
            Address.Immutable extragalacticAddress = new Address(tag.getIntArray(dimensionString)).immutable();
            if (this.solarSystems.containsKey(extragalacticAddress)) {
                SolarSystem.Serializable solarSystem = this.solarSystems.get(extragalacticAddress);
                this.dimensions.put(Conversion.stringToDimension(dimensionString), solarSystem);
            }
        });
    }

    private void deserializeGalaxies(MinecraftServer server, CompoundTag tag) {
        RegistryAccess.Frozen registries = server.registryAccess();
        Registry galaxyRegistry = registries.registryOrThrow(Galaxy.REGISTRY_KEY);
        tag.getAllKeys().forEach(galaxyString -> {
            ResourceKey<Galaxy> galaxyKey = Conversion.stringToGalaxyKey(galaxyString);
            Galaxy.Serializable galaxy = Galaxy.Serializable.deserialize(server, this.solarSystems, (Registry<Galaxy>)galaxyRegistry, galaxyKey, tag.getCompound(galaxyString));
            this.galaxies.put(galaxy.getKey().location(), galaxy);
        });
    }

    public Universe(MinecraftServer server) {
        this.server = server;
    }

    public static Universe create(MinecraftServer server) {
        return new Universe(server);
    }

    public static Universe load(MinecraftServer server, CompoundTag tag) {
        Universe data = Universe.create(server);
        data.server = server;
        data.deserialize(server, tag);
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag = this.serialize();
        return tag;
    }

    public static SavedData.Factory<Universe> dataFactory(MinecraftServer server) {
        return new SavedData.Factory(() -> Universe.create(server), (tag, provider) -> Universe.load(server, tag));
    }

    @Nonnull
    public static Universe get(Level level) {
        if (level.isClientSide()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return Universe.get(level.getServer());
    }

    @Nonnull
    public static Universe get(MinecraftServer server) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        return (Universe)storage.computeIfAbsent(Universe.dataFactory(server), FILE_NAME);
    }
}

