/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.sgjourney.common.capabilities.GoauldHost;
import net.povstalec.sgjourney.common.entities.Human;
import net.povstalec.sgjourney.common.entities.goals.NearestHostGoal;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.ItemInit;

public class Goauld
extends AgeableMob {
    public static final float MAX_HEALTH = 6.0f;

    public Goauld(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(3, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new NearestHostGoal<Human>((Mob)this, Human.class));
        this.targetSelector.addGoal(4, new NearestHostGoal<Player>((Mob)this, Player.class));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public boolean doHurtTarget(Entity entity) {
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        boolean damaged = entity.hurt(this.damageSources().mobAttack((LivingEntity)this), damage);
        if (damaged && entity instanceof Mob) {
            GoauldHost cap;
            Mob mob = (Mob)entity;
            if (entity.getClass() == Human.class && (cap = (GoauldHost)mob.getCapability(GoauldHost.GOAULD_HOST_CAPABILITY)) != null) {
                cap.takeOverHost(this, mob);
            }
        }
        return damaged;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SILVERFISH_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SILVERFISH_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SILVERFISH_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.SILVERFISH_STEP, 0.15f, 1.0f);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() || player.level().isClientSide()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = this.saveToItem();
        player.setItemInHand(InteractionHand.MAIN_HAND, stack);
        this.remove(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    public Info goauldInfo() {
        return new Info(this.getCustomName(), this.getHealth(), this.getAge());
    }

    public void setFromInfo(Info goauldInfo) {
        this.setCustomName(goauldInfo.name());
        this.setHealth(goauldInfo.health());
        this.setAge(goauldInfo.age());
    }

    public ItemStack saveToItem() {
        return this.goauldInfo().toItemStack(this.level().getServer());
    }

    public void loadFromItem(ItemStack stack) {
        this.setFromInfo(Info.fromItemStack(this.level().getServer(), stack));
    }

    public static class Info
    implements INBTSerializable<CompoundTag> {
        public static final String GOAULD_INFO = "goauld_info";
        public static final String NAME = "name";
        public static final String HEALTH = "health";
        public static final String AGE = "age";
        @Nullable
        private Component name = null;
        private float health;
        private int age;

        public Info(@Nullable Component name, float health, int age) {
            this.name = name;
            this.health = health;
            this.age = age;
        }

        public Info() {
            this(null, 6.0f, 0);
        }

        @Nullable
        public Component name() {
            return this.name;
        }

        public float health() {
            return this.health;
        }

        public int age() {
            return this.age;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            if (this.name != null) {
                tag.putString(NAME, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
            }
            tag.putFloat(HEALTH, this.health);
            tag.putInt(AGE, this.age);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            if (tag.contains(NAME, 8)) {
                this.name = Component.Serializer.fromJson((String)tag.getString(NAME), (HolderLookup.Provider)provider);
            }
            this.health = tag.getFloat(HEALTH);
            this.age = tag.getInt(AGE);
        }

        public Info copy() {
            return new Info(this.name, this.health, this.age);
        }

        public static Info fromItemStack(MinecraftServer server, ItemStack stack) {
            Info goauldInfo = new Info();
            if (stack.get(DataComponentInit.GOAULD_INFO) != null) {
                goauldInfo.deserializeNBT((HolderLookup.Provider)server.registryAccess(), (CompoundTag)stack.get(DataComponentInit.GOAULD_INFO));
            }
            if (stack.get(DataComponents.CUSTOM_NAME) != null) {
                goauldInfo.name = (Component)stack.get(DataComponents.CUSTOM_NAME);
            }
            return goauldInfo;
        }

        public ItemStack toItemStack(MinecraftServer server) {
            ItemStack goauldStack = new ItemStack((ItemLike)ItemInit.GOAULD.get());
            goauldStack.set(DataComponentInit.GOAULD_INFO, (Object)this.serializeNBT((HolderLookup.Provider)server.registryAccess()));
            if (this.name != null) {
                goauldStack.set(DataComponents.CUSTOM_NAME, (Object)this.name);
            }
            return goauldStack;
        }
    }
}

