/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.povstalec.sgjourney.common.init.TagInit;

public class PlasmaProjectile
extends Projectile {
    private float explosionPower = 0.0f;

    public PlasmaProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    public PlasmaProjectile(EntityType<? extends Projectile> type, LivingEntity shooter, Level level, float explosionPower) {
        super(type, level);
        this.explosionPower = explosionPower;
        this.setPos(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        this.setOwner((Entity)shooter);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide()) {
            boolean canDestroy = EventHooks.canEntityGrief((Level)this.level(), (Entity)this.getOwner());
            this.level().explode(this.getOwner(), this.getX(), this.getY(), this.getZ(), this.explosionPower, canDestroy, canDestroy ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        if (!this.level().isClientSide()) {
            Entity entity = hitResult.getEntity();
            Entity attacker = this.getOwner();
            DamageSource source = this.level().damageSources().explosion(entity, attacker);
            entity.hurt(source, 14.0f);
            if (attacker instanceof LivingEntity) {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)entity, (DamageSource)source);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        Entity entity;
        super.onHitBlock(result);
        if (!(this.level().isClientSide() || (entity = this.getOwner()) instanceof Mob && !EventHooks.canEntityGrief((Level)this.level(), (Entity)entity))) {
            BlockPos blockpos = result.getBlockPos().relative(result.getDirection());
            if (this.level().isEmptyBlock(blockpos)) {
                for (Direction direction : Direction.values()) {
                    this.trySetFireToBlock(blockpos, blockpos.relative(direction), direction);
                }
            }
        }
    }

    private boolean trySetFireToBlock(BlockPos blockpos, BlockPos nearbyPos, Direction direction) {
        if (this.level().getBlockState(nearbyPos).is(TagInit.Blocks.PLASMA_FLAMMABLE) && !EventHooks.onBlockPlace((Entity)this.getOwner(), (BlockSnapshot)BlockSnapshot.create((ResourceKey)this.level().dimension(), (LevelAccessor)this.level(), (BlockPos)blockpos), (Direction)direction)) {
            this.level().setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockpos));
            return true;
        }
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        float f;
        super.tick();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f1 = 0.25f;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.setDeltaMovement(vec3.scale((double)f));
        this.applyGravity();
        this.setPos(d0, d1, d2);
    }

    protected double getDefaultGravity() {
        return 0.03;
    }
}

