/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.povstalec.sgjourney.common.blocks.ATAGeneDetectorBlock;
import net.povstalec.sgjourney.common.blocks.ArcheologyTableBlock;
import net.povstalec.sgjourney.common.blocks.BuddingUnityBlock;
import net.povstalec.sgjourney.common.blocks.CartoucheBlock;
import net.povstalec.sgjourney.common.blocks.ChevronBlock;
import net.povstalec.sgjourney.common.blocks.ExplosiveBlock;
import net.povstalec.sgjourney.common.blocks.FirePitBlock;
import net.povstalec.sgjourney.common.blocks.GoldenIdolBlock;
import net.povstalec.sgjourney.common.blocks.SecretSwitchBlock;
import net.povstalec.sgjourney.common.blocks.SymbolBlock;
import net.povstalec.sgjourney.common.blocks.UnityClusterBlock;
import net.povstalec.sgjourney.common.blocks.dhd.AbstractDHDBlock;
import net.povstalec.sgjourney.common.blocks.dhd.ClassicDHDBlock;
import net.povstalec.sgjourney.common.blocks.dhd.MilkyWayDHDBlock;
import net.povstalec.sgjourney.common.blocks.dhd.PegasusDHDBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.MilkyWayStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.MilkyWayStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.PegasusStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.PegasusStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.TollanStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.TollanStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.UniverseStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.UniverseStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.GenericShieldingBlock;
import net.povstalec.sgjourney.common.blocks.tech.AdvancedCrystallizerBlock;
import net.povstalec.sgjourney.common.blocks.tech.BatteryBlock;
import net.povstalec.sgjourney.common.blocks.tech.CableBlock;
import net.povstalec.sgjourney.common.blocks.tech.CrystallizerBlock;
import net.povstalec.sgjourney.common.blocks.tech.HeavyNaquadahLiquidizerBlock;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahGeneratorMarkIBlock;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahGeneratorMarkIIBlock;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahLiquidizerBlock;
import net.povstalec.sgjourney.common.blocks.tech.TransceiverBlock;
import net.povstalec.sgjourney.common.blocks.tech.ZPMHubBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.AdvancedCrystalInterfaceBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.BasicInterfaceBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.CrystalInterfaceBlock;
import net.povstalec.sgjourney.common.blocks.transporter.RingPanelBlock;
import net.povstalec.sgjourney.common.blocks.transporter.TransportRingsBlock;
import net.povstalec.sgjourney.common.config.CommonInterfaceConfig;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.blocks.CartoucheBlockItem;
import net.povstalec.sgjourney.common.items.blocks.DHDItem;
import net.povstalec.sgjourney.common.items.blocks.EnergyBlockItem;
import net.povstalec.sgjourney.common.items.blocks.StargateBlockItem;
import net.povstalec.sgjourney.common.items.blocks.TransporterBlockItem;

public class BlockInit {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"sgjourney");
    public static final DeferredBlock<UniverseStargateBlock> UNIVERSE_STARGATE = BlockInit.registerStargateBlock("universe_stargate", () -> new UniverseStargateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f).sound(SoundType.METAL).noOcclusion()), Rarity.EPIC);
    public static final DeferredBlock<UniverseStargateRingBlock> UNIVERSE_RING = BLOCKS.register("universe_ring", () -> new UniverseStargateRingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f).sound(SoundType.METAL).noOcclusion()));
    public static final DeferredBlock<GenericShieldingBlock> UNIVERSE_SHIELDING = BLOCKS.register("universe_shielding", () -> new GenericShieldingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f).sound(SoundType.METAL).noOcclusion(), 7.0, 1.0));
    public static final DeferredBlock<MilkyWayStargateBlock> MILKY_WAY_STARGATE = BlockInit.registerStargateBlock("milky_way_stargate", () -> new MilkyWayStargateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f, 1200.0f).sound(SoundType.METAL).noOcclusion()), Rarity.EPIC);
    public static final DeferredBlock<MilkyWayStargateRingBlock> MILKY_WAY_RING = BLOCKS.register("milky_way_ring", () -> new MilkyWayStargateRingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f, 1200.0f).sound(SoundType.METAL).noOcclusion()));
    public static final DeferredBlock<GenericShieldingBlock> MILKY_WAY_SHIELDING = BLOCKS.register("milky_way_shielding", () -> new GenericShieldingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f).sound(SoundType.METAL).noOcclusion(), 7.0, 1.0));
    public static final DeferredBlock<PegasusStargateBlock> PEGASUS_STARGATE = BlockInit.registerStargateBlock("pegasus_stargate", () -> new PegasusStargateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f, 1200.0f).sound(SoundType.METAL).noOcclusion()), Rarity.EPIC);
    public static final DeferredBlock<PegasusStargateRingBlock> PEGASUS_RING = BLOCKS.register("pegasus_ring", () -> new PegasusStargateRingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f, 1200.0f).sound(SoundType.METAL).noOcclusion()));
    public static final DeferredBlock<GenericShieldingBlock> PEGASUS_SHIELDING = BLOCKS.register("pegasus_shielding", () -> new GenericShieldingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f).sound(SoundType.METAL).noOcclusion(), 7.0, 1.0));
    public static final DeferredBlock<ClassicStargateBlock> CLASSIC_STARGATE = BlockInit.registerStargateBlock("classic_stargate", () -> new ClassicStargateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f).sound(SoundType.METAL).noOcclusion()), Rarity.UNCOMMON);
    public static final DeferredBlock<ClassicStargateRingBlock> CLASSIC_RING = BLOCKS.register("classic_ring", () -> new ClassicStargateRingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f).sound(SoundType.METAL).noOcclusion()));
    public static final DeferredBlock<GenericShieldingBlock> CLASSIC_SHIELDING = BLOCKS.register("classic_shielding", () -> new GenericShieldingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f).sound(SoundType.METAL).noOcclusion(), 7.0, 1.0));
    public static final DeferredBlock<ClassicStargateBaseBlock> CLASSIC_STARGATE_BASE_BLOCK = BlockInit.registerBlock("classic_stargate_base_block", () -> new ClassicStargateBaseBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f)), Rarity.UNCOMMON, 64);
    public static final DeferredBlock<Block> CLASSIC_STARGATE_CHEVRON_BLOCK = BlockInit.registerBlock("classic_stargate_chevron_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f)), Rarity.UNCOMMON, 64);
    public static final DeferredBlock<Block> CLASSIC_STARGATE_RING_BLOCK = BlockInit.registerBlock("classic_stargate_ring_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f)), Rarity.UNCOMMON, 64);
    public static final DeferredBlock<TollanStargateBlock> TOLLAN_STARGATE = BlockInit.registerStargateBlock("tollan_stargate", () -> new TollanStargateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f, 1200.0f).sound(SoundType.METAL).noOcclusion()), Rarity.EPIC);
    public static final DeferredBlock<TollanStargateRingBlock> TOLLAN_RING = BLOCKS.register("tollan_ring", () -> new TollanStargateRingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f, 1200.0f).sound(SoundType.METAL).noOcclusion()));
    public static final DeferredBlock<AbstractDHDBlock> MILKY_WAY_DHD = BlockInit.registerDHDBlock("milky_way_dhd", () -> new MilkyWayDHDBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f).sound(SoundType.METAL).noOcclusion()), Rarity.RARE);
    public static final DeferredBlock<AbstractDHDBlock> PEGASUS_DHD = BlockInit.registerDHDBlock("pegasus_dhd", () -> new PegasusDHDBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 600.0f).sound(SoundType.METAL).noOcclusion()), Rarity.RARE);
    public static final DeferredBlock<AbstractDHDBlock> CLASSIC_DHD = BlockInit.registerDHDBlock("classic_dhd", () -> new ClassicDHDBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f).sound(SoundType.METAL).noOcclusion()), Rarity.UNCOMMON);
    public static final DeferredBlock<ChevronBlock> UNIVERSE_STARGATE_CHEVRON = BlockInit.registerBlock("universe_stargate_chevron", () -> new ChevronBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f).requiresCorrectToolForDrops().noOcclusion().noCollission().lightLevel(BlockInit.litBlockEmission(7))), Rarity.UNCOMMON, 16);
    public static final DeferredBlock<TransportRingsBlock> TRANSPORT_RINGS = BlockInit.registerTransporterBlock("transport_rings", () -> new TransportRingsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f).sound(SoundType.METAL).noOcclusion()), Rarity.RARE);
    public static final DeferredBlock<RingPanelBlock> RING_PANEL = BlockInit.registerBlock("ring_panel", () -> new RingPanelBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f).sound(SoundType.METAL).noOcclusion()), Rarity.RARE, 1);
    public static final DeferredBlock<ColoredFallingBlock> SULFUR_SAND = BlockInit.registerBlock("sulfur_sand", () -> new ColoredFallingBlock(new ColorRGBA(16443180), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(0.5f).sound(SoundType.SAND)));
    public static final DeferredBlock<BuddingUnityBlock> BUDDING_UNITY = BlockInit.registerBlock("budding_unity", () -> new BuddingUnityBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(0.5f).sound(SoundType.SAND).randomTicks()));
    public static final DeferredBlock<UnityClusterBlock> SMALL_UNITY_BUD = BlockInit.registerBlock("small_unity_bud", () -> new UnityClusterBlock(3, 4, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(1.5f).sound(SoundType.GLASS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<UnityClusterBlock> MEDIUM_UNITY_BUD = BlockInit.registerBlock("medium_unity_bud", () -> new UnityClusterBlock(4, 3, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(1.5f).sound(SoundType.GLASS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<UnityClusterBlock> LARGE_UNITY_BUD = BlockInit.registerBlock("large_unity_bud", () -> new UnityClusterBlock(5, 3, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(1.5f).sound(SoundType.GLASS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<UnityClusterBlock> UNITY_CLUSTER = BlockInit.registerBlock("unity_cluster", () -> new UnityClusterBlock(7, 3, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(1.5f).sound(SoundType.GLASS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<ExplosiveBlock> NAQUADAH_ORE = BlockInit.registerBlock("naquadah_ore", () -> new ExplosiveBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f).requiresCorrectToolForDrops(), 4.0f));
    public static final DeferredBlock<ExplosiveBlock> NETHER_NAQUADAH_ORE = BlockInit.registerBlock("nether_naquadah_ore", () -> new ExplosiveBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f).requiresCorrectToolForDrops(), 4.0f));
    public static final DeferredBlock<ExplosiveBlock> DEEPSLATE_NAQUADAH_ORE = BlockInit.registerBlock("deepslate_naquadah_ore", () -> new ExplosiveBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).requiresCorrectToolForDrops(), 4.0f));
    public static final DeferredBlock<ExplosiveBlock> RAW_NAQUADAH_BLOCK = BlockInit.registerBlock("raw_naquadah_block", () -> new ExplosiveBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), 10.0f));
    public static final DeferredBlock<ExplosiveBlock> PURE_NAQUADAH_BLOCK = BlockInit.registerBlock("pure_naquadah_block", () -> new ExplosiveBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), 20.0f), Rarity.UNCOMMON, 64);
    public static final DeferredBlock<LiquidBlock> LIQUID_NAQUADAH_BLOCK = BlockInit.registerBlock("liquid_naquadah", () -> new LiquidBlock((FlowingFluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get(), BlockBehaviour.Properties.of().mapColor(MapColor.WATER).noCollission().strength(100.0f).noLootTable()));
    public static final DeferredBlock<LiquidBlock> HEAVY_LIQUID_NAQUADAH_BLOCK = BlockInit.registerBlock("heavy_liquid_naquadah", () -> new LiquidBlock((FlowingFluid)FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get(), BlockBehaviour.Properties.of().mapColor(MapColor.WATER).noCollission().strength(100.0f).noLootTable()));
    public static final DeferredBlock<Block> NAQUADAH_BLOCK = BlockInit.registerBlock("naquadah_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 9.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> NAQUADAH_STAIRS = BlockInit.registerBlock("naquadah_stairs", () -> new StairBlock(((Block)NAQUADAH_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 9.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> NAQUADAH_SLAB = BlockInit.registerBlock("naquadah_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 9.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CUT_NAQUADAH_BLOCK = BlockInit.registerBlock("cut_naquadah_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 9.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CUT_NAQUADAH_STAIRS = BlockInit.registerBlock("cut_naquadah_stairs", () -> new StairBlock(((Block)NAQUADAH_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 9.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CUT_NAQUADAH_SLAB = BlockInit.registerBlock("cut_naquadah_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 9.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<GoldenIdolBlock> GOLDEN_IDOL = BlockInit.registerBlock("golden_idol", () -> new GoldenIdolBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).strength(3.0f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops()), Rarity.UNCOMMON, 16);
    public static final DeferredBlock<ArcheologyTableBlock> ARCHEOLOGY_TABLE = BlockInit.registerBlock("archeology_table", () -> new ArcheologyTableBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f, 3.0f).sound(SoundType.WOOD).noOcclusion()));
    public static final DeferredBlock<FirePitBlock> FIRE_PIT = BlockInit.registerBlock("fire_pit", () -> new FirePitBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instabreak().sound(SoundType.STONE).lightLevel(state -> (Boolean)state.getValue((Property)FirePitBlock.LIT) != false ? 15 : 0), (ParticleOptions)ParticleTypes.FLAME));
    public static final DeferredBlock<Block> SANDSTONE_WITH_LAPIS = BlockInit.registerBlock("sandstone_with_lapis", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<RotatedPillarBlock> SANDSTONE_WITH_GOLD = BlockInit.registerBlock("sandstone_with_gold", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<RotatedPillarBlock> SANDSTONE_HIEROGLYPHS = BlockInit.registerBlock("sandstone_hieroglyphs", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SecretSwitchBlock> SANDSTONE_SWITCH = BlockInit.registerBlock("sandstone_switch", () -> new SecretSwitchBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> RED_SANDSTONE_WITH_LAPIS = BlockInit.registerBlock("red_sandstone_with_lapis", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> RED_SANDSTONE_WITH_GOLD = BlockInit.registerBlock("red_sandstone_with_gold", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> RED_SANDSTONE_GLYPHS = BlockInit.registerBlock("red_sandstone_glyphs", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<CartoucheBlock> SANDSTONE_CARTOUCHE = BlockInit.registerCartoucheBlock("sandstone_cartouche", () -> new CartoucheBlock.Sandstone(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<CartoucheBlock> RED_SANDSTONE_CARTOUCHE = BlockInit.registerCartoucheBlock("red_sandstone_cartouche", () -> new CartoucheBlock.RedSandstone(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<CartoucheBlock> STONE_CARTOUCHE = BlockInit.registerCartoucheBlock("stone_cartouche", () -> new CartoucheBlock.Stone(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SymbolBlock> SANDSTONE_SYMBOL = BlockInit.registerBlock("sandstone_symbol", () -> new SymbolBlock.Sandstone(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SymbolBlock> RED_SANDSTONE_SYMBOL = BlockInit.registerBlock("red_sandstone_symbol", () -> new SymbolBlock.RedSandstone(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SymbolBlock> STONE_SYMBOL = BlockInit.registerBlock("stone_symbol", () -> new SymbolBlock.Stone(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<NaquadahGeneratorMarkIBlock> NAQUADAH_GENERATOR_MARK_I = BlockInit.registerEnergyBlock("naquadah_generator_mark_i", () -> new NaquadahGeneratorMarkIBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f)), () -> (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_i_capacity.get(), Rarity.COMMON);
    public static final DeferredBlock<NaquadahGeneratorMarkIIBlock> NAQUADAH_GENERATOR_MARK_II = BlockInit.registerEnergyBlock("naquadah_generator_mark_ii", () -> new NaquadahGeneratorMarkIIBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f)), () -> (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_ii_capacity.get(), Rarity.COMMON);
    public static final DeferredBlock<BasicInterfaceBlock> BASIC_INTERFACE = BlockInit.registerEnergyBlock("basic_interface", () -> new BasicInterfaceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).isRedstoneConductor(BlockInit::never).strength(5.0f, 6.0f)), () -> (Long)CommonInterfaceConfig.basic_interface_capacity.get(), Rarity.COMMON);
    public static final DeferredBlock<CrystalInterfaceBlock> CRYSTAL_INTERFACE = BlockInit.registerEnergyBlock("crystal_interface", () -> new CrystalInterfaceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).isRedstoneConductor(BlockInit::never).strength(5.0f, 6.0f)), () -> (Long)CommonInterfaceConfig.crystal_interface_capacity.get(), Rarity.UNCOMMON);
    public static final DeferredBlock<AdvancedCrystalInterfaceBlock> ADVANCED_CRYSTAL_INTERFACE = BlockInit.registerEnergyBlock("advanced_crystal_interface", () -> new AdvancedCrystalInterfaceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).isRedstoneConductor(BlockInit::never).strength(5.0f, 6.0f)), () -> (Long)CommonInterfaceConfig.advanced_crystal_interface_capacity.get(), Rarity.RARE);
    public static final DeferredBlock<ATAGeneDetectorBlock> ANCIENT_GENE_DETECTOR = BlockInit.registerBlock("ancient_gene_detector", () -> new ATAGeneDetectorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f)), Rarity.RARE, 1);
    public static final DeferredBlock<ZPMHubBlock> ZPM_HUB = BlockInit.registerBlock("zpm_hub", () -> new ZPMHubBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f)), Rarity.RARE, 1);
    public static final DeferredBlock<NaquadahLiquidizerBlock> NAQUADAH_LIQUIDIZER = BlockInit.registerBlock("naquadah_liquidizer", () -> new NaquadahLiquidizerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f)), 1);
    public static final DeferredBlock<HeavyNaquadahLiquidizerBlock> HEAVY_NAQUADAH_LIQUIDIZER = BlockInit.registerBlock("heavy_naquadah_liquidizer", () -> new HeavyNaquadahLiquidizerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f)), Rarity.UNCOMMON, 1);
    public static final DeferredBlock<CrystallizerBlock> CRYSTALLIZER = BlockInit.registerBlock("crystallizer", () -> new CrystallizerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f)), Rarity.UNCOMMON, 1);
    public static final DeferredBlock<AdvancedCrystallizerBlock> ADVANCED_CRYSTALLIZER = BlockInit.registerBlock("advanced_crystallizer", () -> new AdvancedCrystallizerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f)), Rarity.RARE, 1);
    public static final DeferredBlock<TransceiverBlock> TRANSCEIVER = BlockInit.registerBlock("transceiver", () -> new TransceiverBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f)), 1);
    public static final DeferredBlock<CableBlock> NAQUADAH_WIRE = BlockInit.registerBlock("naquadah_wire", () -> new CableBlock.NaquadahWire(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 6.0f).noOcclusion()), 64);
    public static final DeferredBlock<CableBlock> SMALL_NAQUADAH_CABLE = BlockInit.registerBlock("small_naquadah_cable", () -> new CableBlock.SmallNaquadahCable(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops()), 64);
    public static final DeferredBlock<CableBlock> MEDIUM_NAQUADAH_CABLE = BlockInit.registerBlock("medium_naquadah_cable", () -> new CableBlock.MediumNaquadahCable(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 6.0f).noOcclusion().requiresCorrectToolForDrops()), Rarity.UNCOMMON, 64);
    public static final DeferredBlock<CableBlock> LARGE_NAQUADAH_CABLE = BlockInit.registerBlock("large_naquadah_cable", () -> new CableBlock.LargeNaquadahCable(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f).noOcclusion().requiresCorrectToolForDrops()), Rarity.RARE, 64);
    public static final DeferredBlock<BatteryBlock> LARGE_NAQUADAH_BATTERY = BlockInit.registerEnergyBlock("large_naquadah_battery", () -> new BatteryBlock.Naquadah(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f)), () -> (Long)CommonTechConfig.large_naquadah_battery_capacity.get(), Rarity.RARE);

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block, int stacksTo) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn, stacksTo);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block, Rarity rarity, int stacksTo) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn, rarity, stacksTo);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerStargateBlock(String name, Supplier<T> block, Rarity rarity) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerStargateBlockItem(name, toReturn, rarity, 1);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerTransporterBlock(String name, Supplier<T> block, Rarity rarity) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerTransporterBlockItem(name, toReturn, rarity, 1);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerDHDBlock(String name, Supplier<T> block, Rarity rarity) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerDHDItem(name, toReturn, rarity, 1);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerCartoucheBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerCartoucheBlockItem(name, toReturn, 1);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerEnergyBlock(String name, Supplier<T> block, EnergyBlockItem.CapacityGetter getter, Rarity rarity) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerEnergyBlockItem(name, toReturn, getter, rarity);
        return toReturn;
    }

    private static <T extends Block> DeferredItem<Item> registerBlockItem(String name, DeferredBlock<T> block) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> DeferredItem<Item> registerBlockItem(String name, DeferredBlock<T> block, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().stacksTo(stacksTo)));
    }

    private static <T extends Block> DeferredItem<Item> registerBlockItem(String name, DeferredBlock<T> block, Rarity rarity, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().rarity(rarity).stacksTo(stacksTo)));
    }

    private static <T extends Block> DeferredItem<Item> registerStargateBlockItem(String name, DeferredBlock<T> block, Rarity rarity, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new StargateBlockItem((Block)block.get(), new Item.Properties().rarity(rarity).stacksTo(stacksTo).fireResistant()));
    }

    private static <T extends Block> DeferredItem<Item> registerTransporterBlockItem(String name, DeferredBlock<T> block, Rarity rarity, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new TransporterBlockItem((Block)block.get(), new Item.Properties().rarity(rarity).stacksTo(stacksTo).fireResistant()));
    }

    private static <T extends Block> DeferredItem<Item> registerDHDItem(String name, DeferredBlock<T> block, Rarity rarity, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new DHDItem((Block)block.get(), new Item.Properties().rarity(rarity).stacksTo(stacksTo)));
    }

    private static <T extends Block> DeferredItem<Item> registerCartoucheBlockItem(String name, DeferredBlock<T> block, int stacksTo) {
        return ItemInit.ITEMS.register(name, () -> new CartoucheBlockItem((Block)block.get(), new Item.Properties().stacksTo(stacksTo)));
    }

    private static <T extends Block> DeferredItem<Item> registerEnergyBlockItem(String name, DeferredBlock<T> block, EnergyBlockItem.CapacityGetter getter, Rarity rarity) {
        return ItemInit.ITEMS.register(name, () -> new EnergyBlockItem.Getter((Block)block.get(), new Item.Properties().rarity(rarity).stacksTo(1), getter));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }
}

