/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.sgjourney.transporter.TransportRings;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class TransporterInit {
    private static final HashMap<ResourceLocation, TransporterConstructor> TRANSPORTERS = new HashMap();
    private static final HashMap<Class<? extends Transporter>, ResourceLocation> LOCATIONS = new HashMap();

    public static <T extends Transporter> void register(ResourceLocation resourceLocation, Class<T> objectClass, TransporterConstructor<T> constructor) {
        if (TRANSPORTERS.containsKey(resourceLocation)) {
            throw new IllegalStateException("Duplicate registration for " + resourceLocation.toString());
        }
        if (LOCATIONS.containsKey(objectClass)) {
            throw new IllegalStateException("Duplicate registration for " + objectClass.getName());
        }
        TRANSPORTERS.put(resourceLocation, constructor);
        LOCATIONS.put(objectClass, resourceLocation);
    }

    @Nullable
    public static Transporter constructTransporter(ResourceLocation resourceLocation) {
        if (TRANSPORTERS.containsKey(resourceLocation)) {
            return TRANSPORTERS.get(resourceLocation).create();
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocation(Transporter transporter) {
        if (transporter != null && LOCATIONS.containsKey(transporter.getClass())) {
            return LOCATIONS.get(transporter.getClass());
        }
        return null;
    }

    public static void register() {
        TransporterInit.register(StargateJourney.sgjourneyLocation("transport_rings"), TransportRings.class, TransportRings::new);
    }

    public static interface TransporterConstructor<T extends Transporter> {
        public T create();
    }
}

