/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;

public class BatteryItem
extends Item {
    public static final String ENERGY = "energy";

    public BatteryItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)BatteryItem.getEnergy(stack) / (float)this.getCapacity());
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)BatteryItem.getEnergy(stack) / (float)this.getCapacity());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static CompoundTag tagSetup(int energy) {
        CompoundTag tag = new CompoundTag();
        tag.putInt(ENERGY, energy);
        return tag;
    }

    public static long getEnergy(ItemStack stack) {
        return (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)0L);
    }

    public long getCapacity() {
        return (Long)CommonTechConfig.small_naquadah_battery_capacity.get();
    }

    public long getTransfer() {
        return (Long)CommonTechConfig.small_naquadah_battery_max_transfer.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.energy").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(BatteryItem.getEnergy(stack), this.getCapacity())))).withStyle(ChatFormatting.DARK_RED));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class Energy
    extends SGJourneyEnergy.Item {
        public Energy(ItemStack stack) {
            super(stack, 0L, 0L, 0L);
        }

        @Override
        public long maxReceive() {
            Item item = this.stack.getItem();
            if (item instanceof BatteryItem) {
                BatteryItem battery = (BatteryItem)item;
                return battery.getTransfer();
            }
            return 0L;
        }

        @Override
        public long maxExtract() {
            Item item = this.stack.getItem();
            if (item instanceof BatteryItem) {
                BatteryItem battery = (BatteryItem)item;
                return battery.getTransfer();
            }
            return 0L;
        }

        @Override
        public long loadEnergy(ItemStack stack) {
            return (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)0L);
        }

        @Override
        public long getTrueMaxEnergyStored() {
            Item item = this.stack.getItem();
            if (item instanceof BatteryItem) {
                BatteryItem battery = (BatteryItem)item;
                return battery.getCapacity();
            }
            return 0L;
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            this.stack.set(DataComponentInit.ENERGY, (Object)this.energy);
        }
    }
}

