/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.misc.ComponentHelper;

public class NaquadahFuelRodItem
extends Item {
    public NaquadahFuelRodItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack fuelRodSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.NAQUADAH_FUEL_ROD.get());
        stack.set(DataComponentInit.NAQUADAH_FUEL, (Object)((Integer)CommonNaquadahGeneratorConfig.naquadah_rod_max_fuel.get()));
        return stack;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)NaquadahFuelRodItem.getFuel(stack) / (float)NaquadahFuelRodItem.getMaxFuel());
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)NaquadahFuelRodItem.getFuel(stack) / (float)NaquadahFuelRodItem.getMaxFuel());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static int getFuel(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.NAQUADAH_FUEL, (Object)((Integer)CommonNaquadahGeneratorConfig.naquadah_rod_max_fuel.get()));
    }

    public static boolean depleteFuel(ItemStack stack) {
        int fuel = (Integer)stack.getOrDefault(DataComponentInit.NAQUADAH_FUEL, (Object)0);
        if (fuel > 0) {
            stack.set(DataComponentInit.NAQUADAH_FUEL, (Object)(--fuel));
            return true;
        }
        return true;
    }

    public static int getMaxFuel() {
        return (Integer)CommonNaquadahGeneratorConfig.naquadah_rod_max_fuel.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (tooltipFlag.isAdvanced()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.naquadah_fuel_rod.fuel").append((Component)Component.literal((String)(": " + NaquadahFuelRodItem.getFuel(stack) + " / " + NaquadahFuelRodItem.getMaxFuel()))).withStyle(ChatFormatting.GREEN));
        }
        tooltipComponents.add((Component)ComponentHelper.description("tooltip.sgjourney.naquadah_fuel_rod.description"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static ItemStack randomFuelRod(int minCapacity, int maxCapacity) {
        ItemStack fusionCore = new ItemStack((ItemLike)ItemInit.NAQUADAH_FUEL_ROD.get());
        Random random = new Random();
        fusionCore.set(DataComponentInit.NAQUADAH_FUEL, (Object)random.nextInt(minCapacity, maxCapacity + 1));
        return fusionCore;
    }
}

