/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.tech.AncientTech;
import net.povstalec.sgjourney.common.tech.GoauldTech;

public class PDAItem
extends Item
implements AncientTech,
GoauldTech {
    public PDAItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos blockpos = context.getClickedPos();
        BlockState state = level.getBlockState(blockpos);
        Block block = state.getBlock();
        if (!level.isClientSide()) {
            player.sendSystemMessage((Component)Component.translatable((String)block.getDescriptionId()).withStyle(ChatFormatting.GRAY));
        }
        if (block instanceof AbstractStargateRingBlock) {
            blockpos = ((StargatePart)((Object)state.getValue((Property)AbstractStargateRingBlock.PART))).getBaseBlockPos(blockpos, (Direction)state.getValue((Property)AbstractStargateRingBlock.FACING), (Orientation)((Object)state.getValue((Property)AbstractStargateRingBlock.ORIENTATION)));
        }
        if ((blockEntity = level.getBlockEntity(blockpos)) instanceof EnergyBlockEntity) {
            EnergyBlockEntity blockEntity2 = (EnergyBlockEntity)blockEntity;
            blockEntity2.getStatus(player);
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide() && player.isShiftKeyDown()) {
            this.scanEntity(player, (Entity)player);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.level().isClientSide()) {
            this.scanEntity(player, (Entity)target);
        }
        return super.interactLivingEntity(stack, player, target, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.pda.info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    private void scanEntity(Player user, Entity target) {
        user.sendSystemMessage((Component)target.getName().copy().withStyle(ChatFormatting.YELLOW));
        if (this.canUseGoauldTech(target)) {
            user.sendSystemMessage((Component)Component.translatable((String)"message.sgjourney.pda.has_naquadah_in_bloodstream").withStyle(ChatFormatting.DARK_GREEN));
        }
        if (this.canUseAncientTech(target)) {
            user.sendSystemMessage((Component)Component.translatable((String)"message.sgjourney.pda.has_ancient_gene").withStyle(ChatFormatting.AQUA));
        }
    }
}

