/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.TransportRingsEntity;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.crystals.MemoryCrystalItem;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class RingRemoteItem
extends Item {
    public RingRemoteItem(Item.Properties properties) {
        super(properties);
    }

    protected List<TransportRingsEntity> getNearbyTransportRings(Level level, BlockPos blockPos, int maxDistance) {
        ArrayList<TransportRingsEntity> transporters = new ArrayList<TransportRingsEntity>();
        for (int x = -maxDistance / 16; x <= maxDistance / 16; ++x) {
            for (int z = -maxDistance / 16; z <= maxDistance / 16; ++z) {
                ChunkAccess chunk = level.getChunk(blockPos.east(16 * x).south(16 * z));
                Set positions = chunk.getBlockEntitiesPos();
                positions.stream().forEach(pos -> {
                    BlockEntity patt0$temp = level.getBlockEntity(pos);
                    if (patt0$temp instanceof TransportRingsEntity) {
                        TransportRingsEntity transportRings = (TransportRingsEntity)patt0$temp;
                        transporters.add(transportRings);
                    }
                });
            }
        }
        return transporters;
    }

    public Optional<TransportRingsEntity> findNearestTransportRings(Level level, BlockPos blockPos, int maxDistance) {
        List<TransportRingsEntity> transporters = this.getNearbyTransportRings(level, blockPos, maxDistance);
        transporters.sort(Comparator.comparing(transporter -> blockPos.distSqr((Vec3i)transporter.getBlockPos())));
        if (!transporters.isEmpty()) {
            return Optional.of(transporters.get(0));
        }
        return Optional.empty();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && !level.isClientSide()) {
            IItemHandler cap;
            ItemStack mainHandStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            ItemStack offHandStack = player.getItemInHand(InteractionHand.OFF_HAND);
            if (offHandStack.is((Item)ItemInit.RING_REMOTE.get()) && (cap = (IItemHandler)offHandStack.getCapability(Capabilities.ItemHandler.ITEM)) != null) {
                ItemStack returnStack = !mainHandStack.isEmpty() ? cap.insertItem(0, mainHandStack, false) : cap.extractItem(0, 1, false);
                player.setItemInHand(InteractionHand.MAIN_HAND, returnStack);
            }
        } else if (!player.isShiftKeyDown()) {
            // empty if block
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    @Nullable
    private static Transporter transporterFromUUID(Level level, UUID uuid) {
        return TransporterNetwork.get(level).getTransporter(uuid);
    }

    @Nullable
    private static Transporter transporterFromCoords(Level level, Vec3i coords) {
        BlockEntity blockEntity = level.getBlockEntity(new BlockPos(coords.getX(), coords.getY(), coords.getZ()));
        if (blockEntity instanceof AbstractTransporterEntity) {
            AbstractTransporterEntity transporter = (AbstractTransporterEntity)blockEntity;
            return transporter.getTransporter();
        }
        return null;
    }

    private void tryStartTransport(Level level, Player player, @Nullable Transporter target) {
        Optional<TransportRingsEntity> transportRings = this.findNearestTransportRings(level, player.blockPosition(), 16);
        if (transportRings.isPresent()) {
            if (target != null && transportRings.get().canTransport() && transportRings.get().canTransport()) {
                transportRings.get().startTransport(target);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.ring_remote.error.transport_rings_busy").withStyle(ChatFormatting.BLUE), true);
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.ring_remote.error.no_transport_rings_nearby").withStyle(ChatFormatting.BLUE), true);
        }
    }

    public static boolean canActivate(ItemStack stack) {
        if (stack.is((Item)ItemInit.RING_REMOTE.get())) {
            IItemHandler itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            if (itemHandler != null) {
                return !itemHandler.getStackInSlot(0).isEmpty();
            }
            return false;
        }
        return false;
    }

    private int[] findFirstCoords(ItemStack memoryCrystal) {
        int[] address = new int[]{};
        return address;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ItemStack crystalStack;
        Item item;
        IItemHandler itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler != null && (item = (crystalStack = itemHandler.getStackInSlot(0)).getItem()) instanceof MemoryCrystalItem) {
            MemoryCrystalItem crystal = (MemoryCrystalItem)item;
            tooltipComponents.add((Component)Component.translatable((String)"item.sgjourney.memory_crystal").withStyle(ChatFormatting.BLUE));
            ListTag list = MemoryCrystalItem.getMemoryList(crystalStack);
            for (int i = 0; i < list.size(); ++i) {
                tooltipComponents.add((Component)Component.literal((String)("[" + i + "] ")).append(this.memoryTypeAt(stack, list, i)));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private Component memoryTypeAt(ItemStack stack, ListTag list, int index) {
        if (list.getCompound(index).contains("address", 11)) {
            return Component.translatable((String)"tooltip.sgjourney.address").withStyle(ChatFormatting.AQUA);
        }
        Vec3i coords = MemoryCrystalItem.getCoords(list, stack, index);
        if (coords != null) {
            return Component.translatable((String)"tooltip.sgjourney.coordinates").append((Component)Component.literal((String)(" " + coords.toShortString()))).withStyle(ChatFormatting.BLUE);
        }
        UUID id = MemoryCrystalItem.getUUID(list, stack, index);
        if (id != null) {
            return Component.literal((String)id.toString()).withStyle(ChatFormatting.DARK_AQUA);
        }
        return Component.translatable((String)"tooltip.sgjourney.corrupt_data").withStyle(ChatFormatting.DARK_RED);
    }

    public static class ItemHandler
    extends ComponentItemHandler {
        public ItemHandler(MutableDataComponentHolder parent, DataComponentType<ItemContainerContents> component) {
            super(parent, component, 1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.is((Item)ItemInit.MEMORY_CRYSTAL.get());
        }
    }
}

