/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.povstalec.sgjourney.common.entities.PlasmaProjectile;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.FluidItem;
import net.povstalec.sgjourney.common.items.VialItem;

public class StaffWeaponItem
extends FluidItem.Holder {
    private static final float OPEN_ATTACK_DAMAGE = 3.0f;
    private static final float CLOSED_ATTACK_DAMAGE = 6.0f;
    private static final float OPEN_ATTACK_SPEED = -2.4f;
    private static final float CLOSED_ATTACK_SPEED = -2.8f;
    private static final float LIQUID_NAQUADAH_EXPLOSION_POWER = 0.0f;
    private static final float HEAVY_LIQUID_NAQUADAH_EXPLOSION_POWER = 1.0f;
    private static final int LIQUID_NAQUADAH_DEPLETION = 1;
    private static final int HEAVY_LIQUID_NAQUADAH_DEPLETION = 5;
    private final ItemAttributeModifiers openModifiers;
    private final ItemAttributeModifiers closedModifiers;

    public StaffWeaponItem(Item.Properties properties) {
        super(properties);
        ItemAttributeModifiers.Entry damageEntry = new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        ItemAttributeModifiers.Entry speedEntry = new ItemAttributeModifiers.Entry(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-2.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        this.openModifiers = new ItemAttributeModifiers(Arrays.asList(damageEntry, speedEntry), true);
        damageEntry = new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 6.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        speedEntry = new ItemAttributeModifiers.Entry(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-2.8f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        this.closedModifiers = new ItemAttributeModifiers(Arrays.asList(damageEntry, speedEntry), true);
    }

    protected void shoot(Level level, Player player, ItemStack staffWeaponStack) {
        if (!player.isCreative() && !this.tryDepleteLiquidNaquadah(staffWeaponStack)) {
            return;
        }
        level.playSound(player, player.blockPosition(), (SoundEvent)SoundInit.MATOK_FIRE.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
        if (!level.isClientSide()) {
            PlasmaProjectile plasmaProjectile = new PlasmaProjectile((EntityType<? extends Projectile>)((EntityType)EntityInit.JAFFA_PLASMA.get()), (LivingEntity)player, level, this.getExplosionPower(staffWeaponStack));
            plasmaProjectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 5.0f, 1.0f);
            level.addFreshEntity((Entity)plasmaProjectile);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        player.getCooldowns().addCooldown((Item)this, 25);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            ItemStack mainHandStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            ItemStack offHandStack = player.getItemInHand(InteractionHand.OFF_HAND);
            Item item = offHandStack.getItem();
            if (item instanceof StaffWeaponItem) {
                StaffWeaponItem staffWeapon = (StaffWeaponItem)item;
                if (!level.isClientSide() && staffWeapon.swapItem(player, offHandStack, mainHandStack)) {
                    return InteractionResultHolder.success((Object)offHandStack);
                }
                return InteractionResultHolder.pass((Object)stack);
            }
            if (mainHandStack.is((Item)ItemInit.MATOK.get())) {
                StaffWeaponItem.setOpen(level, player, mainHandStack, !StaffWeaponItem.isOpen(mainHandStack));
                player.getCooldowns().addCooldown((Item)this, 15);
            }
        } else if (StaffWeaponItem.isOpen(stack)) {
            this.shoot(level, player, stack);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public float getExplosionPower(ItemStack stack) {
        return this.getFluidStack(stack).getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get() ? 1.0f : 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity player) {
        player.level().playSound((Player)null, player.blockPosition(), (SoundEvent)SoundInit.MATOK_ATTACK.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
        return super.hurtEnemy(stack, target, player);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    @Override
    public ItemStack getHeldItem(ItemStack holderStack) {
        IItemHandler itemHandler = (IItemHandler)holderStack.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler == null) {
            return ItemStack.EMPTY;
        }
        return itemHandler.getStackInSlot(0);
    }

    @Override
    public boolean isCorrectFluid(FluidStack fluidStack) {
        return fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() || fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
    }

    @Override
    public boolean isValidItem(ItemStack heldStack) {
        return heldStack.is((Item)ItemInit.VIAL.get());
    }

    public boolean tryDepleteLiquidNaquadah(ItemStack staffWeaponItemStack) {
        FluidStack fluidStack;
        int drainAmount;
        FluidItem.Holder.FluidItemHandler fluidHolder;
        FluidStack depleted;
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)staffWeaponItemStack.getCapability(Capabilities.FluidHandler.ITEM);
        return fluidHandler instanceof FluidItem.Holder.FluidItemHandler && !(depleted = fluidHolder.deplete(drainAmount = (fluidStack = (fluidHolder = (FluidItem.Holder.FluidItemHandler)fluidHandler).getFluidInTank(0)).getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() ? 1 : 5, IFluidHandler.FluidAction.EXECUTE)).isEmpty();
    }

    public static boolean isOpen(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponentInit.IS_OPEN, (Object)false);
    }

    public static void setOpen(Level level, Player player, ItemStack stack, boolean isOpen) {
        stack.set(DataComponentInit.IS_OPEN, (Object)isOpen);
        level.playSound(player, player.blockPosition(), isOpen ? (SoundEvent)SoundInit.MATOK_OPEN.get() : (SoundEvent)SoundInit.MATOK_CLOSE.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return StaffWeaponItem.isOpen(stack) ? this.openModifiers : this.closedModifiers;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        MutableComponent isOpen = StaffWeaponItem.isOpen(stack) ? Component.translatable((String)"tooltip.sgjourney.matok.open").withStyle(ChatFormatting.YELLOW) : Component.translatable((String)"tooltip.sgjourney.matok.closed").withStyle(ChatFormatting.YELLOW);
        tooltipComponents.add((Component)isOpen);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.matok.open_close").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.matok.reload").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    public static ItemStack filledStaffWeapon(boolean heavyLiquidNaquadah, int amount) {
        ItemStack staffWeapon = new ItemStack((ItemLike)ItemInit.MATOK.get());
        ItemStack vial = heavyLiquidNaquadah ? VialItem.heavyLiquidNaquadahSetup(amount) : VialItem.liquidNaquadahSetup(amount);
        IItemHandler itemHandler = (IItemHandler)staffWeapon.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler != null) {
            itemHandler.insertItem(0, vial, false);
        }
        return staffWeapon;
    }

    public static class FluidItemHandler
    extends FluidItem.Holder.FluidItemHandler {
        public FluidItemHandler(ItemStack stack, DataComponentType<ItemContainerContents> component) {
            super(stack, component);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.is((Item)ItemInit.VIAL.get());
        }
    }
}

