/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.blocks;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.misc.InventoryUtil;

public abstract class EnergyBlockItem
extends BlockItem {
    public EnergyBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public long getEnergy(ItemStack stack) {
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        if (blockEntityTag != null && blockEntityTag.contains("energy", 4)) {
            return blockEntityTag.getLong("energy");
        }
        return 0L;
    }

    public abstract long getCapacity();

    public boolean isBarVisible(ItemStack stack) {
        return this.getEnergy(stack) > 0L;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)this.getEnergy(stack) / (float)this.getCapacity());
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)this.getEnergy(stack) / (float)this.getCapacity());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.energy").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(this.getEnergy(stack), this.getCapacity())))).withStyle(ChatFormatting.DARK_RED));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static interface CapacityGetter {
        public long getCapacity();
    }

    public static class Getter
    extends EnergyBlockItem {
        private CapacityGetter capacityGetter;

        public Getter(Block block, Item.Properties properties, CapacityGetter capacityGetter) {
            super(block, properties);
            this.capacityGetter = capacityGetter;
        }

        @Override
        public long getCapacity() {
            return this.capacityGetter.getCapacity();
        }
    }
}

