/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Address;
import org.jetbrains.annotations.Nullable;

public class MemoryCrystalItem
extends AbstractCrystalItem {
    public static final int DEFAULT_MEMORY_CAPACITY = 5;
    public static final int ADVANCED_MEMORY_CAPACITY = 10;
    public static final String MEMORY_LIST = "memory_list";
    public static final String ID = "id";
    public static final String COORDINATES = "coords";
    public static final String ADDRESS = "address";

    public MemoryCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public int getMemoryCapacity() {
        return 5;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ListTag list = MemoryCrystalItem.getMemoryList(stack);
        for (int i = 0; i < list.size(); ++i) {
            tooltipComponents.add((Component)Component.literal((String)("[" + i + "] ")).append(this.memoryTypeAt(list, i)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private Component memoryTypeAt(ListTag list, int index) {
        if (list.getCompound(index).contains(ADDRESS, 11)) {
            return Component.translatable((String)"tooltip.sgjourney.address").withStyle(ChatFormatting.AQUA);
        }
        if (list.getCompound(index).contains(COORDINATES, 11)) {
            return Component.translatable((String)"tooltip.sgjourney.coordinates").withStyle(ChatFormatting.BLUE);
        }
        if (list.getCompound(index).contains(ID, 8)) {
            return Component.translatable((String)"tooltip.sgjourney.id").withStyle(ChatFormatting.DARK_AQUA);
        }
        return Component.translatable((String)"tooltip.sgjourney.unknown").withStyle(ChatFormatting.DARK_RED);
    }

    private boolean saveMemory(ItemStack stack, CompoundTag memory) {
        ListTag list = MemoryCrystalItem.getMemoryList(stack);
        if (list.size() >= this.getMemoryCapacity()) {
            return false;
        }
        list.add((Object)memory);
        MemoryCrystalItem.setMemoryList(stack, list);
        return true;
    }

    public boolean saveAddress(ItemStack stack, Address.Immutable address) {
        CompoundTag addressTag = new CompoundTag();
        addressTag.putIntArray(ADDRESS, address.toArray());
        return this.saveMemory(stack, addressTag);
    }

    public boolean saveCoords(ItemStack stack, Vec3i coords) {
        CompoundTag coordsTag = new CompoundTag();
        coordsTag.putIntArray(COORDINATES, Conversion.vecToIntArray(coords));
        return this.saveMemory(stack, coordsTag);
    }

    public boolean saveUUID(ItemStack stack, UUID uuid) {
        CompoundTag uuidTag = new CompoundTag();
        uuidTag.putString(ID, uuid.toString());
        return this.saveMemory(stack, uuidTag);
    }

    @Nullable
    public static Address.Immutable getAddress(ListTag list, ItemStack stack, int index) {
        if (list.getCompound(index).contains(ADDRESS, 11)) {
            return new Address.Immutable(list.getCompound(index).getIntArray(ADDRESS));
        }
        return null;
    }

    @Nullable
    public static Address.Immutable getFirstAddress(ListTag list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            Address.Immutable address = MemoryCrystalItem.getAddress(list, stack, i);
            if (address == null) continue;
            return address;
        }
        return null;
    }

    @Nullable
    public static Address.Immutable getFirstAddress(ItemStack stack) {
        return MemoryCrystalItem.getFirstAddress(MemoryCrystalItem.getMemoryList(stack), stack);
    }

    @Nullable
    public static Vec3i getCoords(ListTag list, ItemStack stack, int index) {
        if (list.getCompound(index).contains(COORDINATES, 11)) {
            return Conversion.intArrayToVec(list.getCompound(index).getIntArray(COORDINATES));
        }
        return null;
    }

    @Nullable
    public static Vec3i getFirstCoords(ListTag list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            Vec3i coords = MemoryCrystalItem.getCoords(list, stack, i);
            if (coords == null) continue;
            return coords;
        }
        return null;
    }

    @Nullable
    public static Vec3i getFirstCoords(ItemStack stack) {
        return MemoryCrystalItem.getFirstCoords(MemoryCrystalItem.getMemoryList(stack), stack);
    }

    @Nullable
    public static UUID getUUID(ListTag list, ItemStack stack, int index) {
        if (list.getCompound(index).contains(ID, 8)) {
            try {
                return UUID.fromString(list.getCompound(index).getString(ID));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static UUID getFirstUUID(ListTag list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            UUID uuid = MemoryCrystalItem.getUUID(list, stack, i);
            if (uuid == null) continue;
            return uuid;
        }
        return null;
    }

    @Nullable
    public static UUID getFirstUUID(ItemStack stack) {
        return MemoryCrystalItem.getFirstUUID(MemoryCrystalItem.getMemoryList(stack), stack);
    }

    public static ListTag getMemoryList(ItemStack stack) {
        CompoundTag tag;
        if (stack.getItem() instanceof MemoryCrystalItem && (tag = (CompoundTag)stack.get(DataComponentInit.CRYSTAL_MEMORY)) != null && tag.contains(MEMORY_LIST, 9)) {
            return tag.getList(MEMORY_LIST, 10);
        }
        return new ListTag();
    }

    private static void setMemoryList(ItemStack stack, ListTag list) {
        if (stack.getItem() instanceof MemoryCrystalItem && list != null) {
            CompoundTag tag = new CompoundTag();
            tag.put(MEMORY_LIST, (Tag)list);
            stack.set(DataComponentInit.CRYSTAL_MEMORY, (Object)tag);
        }
    }

    public static class Advanced
    extends MemoryCrystalItem {
        public Advanced(Item.Properties properties) {
            super(properties);
        }

        @Override
        public int getMemoryCapacity() {
            return 10;
        }

        @Override
        public boolean isAdvanced() {
            return true;
        }
    }
}

