/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.ZPMHubEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;

public class ZPMHubMenu
extends InventoryMenu {
    private final ZPMHubEntity blockEntity;
    private final Level level;

    public ZPMHubMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public ZPMHubMenu(int containerId, Inventory inventory, BlockEntity entity) {
        super((MenuType)MenuInit.ZPM_HUB.get(), containerId);
        ZPMHubMenu.checkContainerSize((Container)inventory, (int)1);
        this.blockEntity = (ZPMHubEntity)entity;
        this.level = inventory.player.level();
        this.addPlayerInventory(inventory, 8, 86);
        this.addPlayerHotbar(inventory, 8, 144);
        IItemHandler cap = this.blockEntity.getItemHandler();
        if (cap != null) {
            this.addSlot((Slot)new SlotItemHandler(cap, 0, 80, 35));
        }
    }

    public boolean stillValid(Player player) {
        return ZPMHubMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.ZPM_HUB.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 1;
    }
}

