/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.blockstates.Orientation;

public class CoordinateHelper {

    public static class Relative {
        public static double projectVectorToScalar(Vec3 a, Vec3 b) {
            return a.dot(b) / b.dot(b);
        }

        public static Vec3 projectVector(Vec3 a, Vec3 b) {
            double scalar = Relative.projectVectorToScalar(a, b);
            return b.multiply(scalar, scalar, scalar);
        }

        public static Vec3 fromOrthogonalBasis(Vec3 vector, Vec3 basisX, Vec3 basisY, Vec3 basisZ) {
            double xProj = Relative.projectVectorToScalar(vector, basisX);
            double yProj = Relative.projectVectorToScalar(vector, basisY);
            double zProj = Relative.projectVectorToScalar(vector, basisZ);
            return new Vec3(xProj, yProj, zProj);
        }

        public static Vec3 toOrthogonalBasis(Vec3 vector, Vec3 basisX, Vec3 basisY, Vec3 basisZ) {
            return new Vec3(vector.x() * basisX.x() + vector.y() * basisY.x() + vector.z() * basisZ.x(), vector.x() * basisX.y() + vector.y() * basisY.y() + vector.z() * basisZ.y(), vector.x() * basisX.z() + vector.y() * basisY.z() + vector.z() * basisZ.z());
        }

        public static Vec3 vecRight(Vec3 forward, Vec3 up) {
            return forward.cross(up);
        }

        public static Vec3 mirrorVector(Vec3 vector) {
            return vector.multiply(-1.0, -1.0, -1.0);
        }

        public static Vec3 rotateVector(Vec3 initialVector, Direction initialDirection, Orientation initialOrientation, Direction destinationDirection, Orientation destinationOrientation) {
            Vec3 initialForward = Orientation.getForwardVector(initialDirection, initialOrientation);
            Vec3 initialUp = Orientation.getUpVector(initialDirection, initialOrientation);
            Vec3 destinationForward = Orientation.getForwardVector(destinationDirection, destinationOrientation);
            Vec3 destinationUp = Orientation.getUpVector(destinationDirection, destinationOrientation);
            return Relative.rotateVector(initialVector, initialForward, initialUp, destinationForward, destinationUp);
        }

        public static Vec3 rotateVector(Vec3 initialVector, Vec3 initialForward, Vec3 initialUp, Vec3 destinationForward, Vec3 destinationUp) {
            Vec3 initialRight = initialForward.cross(initialUp);
            Vec3 inbetweenVector = Relative.fromOrthogonalBasis(initialVector, initialForward, initialUp, initialRight);
            Vec3 destinationRight = destinationForward.cross(destinationUp);
            Vec3 destinationVector = Relative.toOrthogonalBasis(inbetweenVector, destinationForward.multiply(-1.0, -1.0, -1.0), destinationUp, destinationRight.multiply(-1.0, -1.0, -1.0));
            return destinationVector;
        }

        public static Vec3 preserveRelative(Direction initialDirection, Orientation initialOrientation, Direction destinationDirection, Orientation destinationOrientation, Vec3 initial) {
            return Relative.rotateVector(initial, initialDirection, initialOrientation, destinationDirection, destinationOrientation);
        }

        public static float preserveYRot(Direction initialDirection, Direction destinationDirection, float yRot) {
            float initialStargateDirection = Mth.wrapDegrees((float)initialDirection.toYRot());
            float destinationStargateDirection = Mth.wrapDegrees((float)destinationDirection.toYRot());
            float relativeRot = destinationStargateDirection - initialStargateDirection;
            yRot = yRot + relativeRot + 180.0f;
            return yRot;
        }

        public static Vec3i yRotateClockwise(Vec3i vector, int numberOfRotations) {
            int x = vector.getX();
            int z = vector.getZ();
            for (int i = 0; i < numberOfRotations; ++i) {
                int helper = x;
                x = -z;
                z = helper;
            }
            return new Vec3i(x, vector.getY(), z);
        }

        public static long distanceSqr(Vec3i posA, Vec3i posB) {
            if (posA == null || posB == null) {
                return Long.MAX_VALUE;
            }
            long x = posB.getX() - posA.getX();
            long y = posB.getY() - posA.getY();
            long z = posB.getZ() - posA.getZ();
            return x * x + y * y + z * z;
        }

        public static double distance(Vec3i posA, Vec3i posB) {
            if (posA == null || posB == null) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.sqrt(Relative.distanceSqr(posA, posB));
        }

        public static Vec3i blockPosOffset(BlockPos initialPos, BlockPos otherPos) {
            return new Vec3i(otherPos.getX() - initialPos.getX(), otherPos.getY() - initialPos.getY(), otherPos.getZ() - initialPos.getZ());
        }

        public static Vec3i getRelativeOffset(Direction initialDirection, BlockPos initialPos, BlockPos otherPos) {
            int initialRotation = initialDirection.get2DDataValue();
            int rotation = -initialRotation;
            if (rotation < 0) {
                rotation += 4;
            }
            Vec3i absoluteOffset = Relative.blockPosOffset(initialPos, otherPos);
            return Relative.yRotateClockwise(absoluteOffset, rotation);
        }

        public static Vec3i getAbsoluteOffset(Direction initialDirection, Vec3i relativeOffset) {
            if (initialDirection == null) {
                return null;
            }
            int destinationRotation = initialDirection.get2DDataValue();
            int rotation = destinationRotation;
            if (rotation < 0) {
                rotation += 4;
            }
            return Relative.yRotateClockwise(relativeOffset, rotation);
        }

        public static BlockPos getOffsetPos(Direction initialDirection, BlockPos initialPos, Vec3i relativeOffset) {
            Vec3i absoluteOffset = Relative.getAbsoluteOffset(initialDirection, relativeOffset);
            if (absoluteOffset == null) {
                return null;
            }
            return initialPos.offset(absoluteOffset);
        }
    }

    public static class CoordinateSystems {
        public static float cartesianToPolarR(float x, float y) {
            return (float)Math.sqrt(x * x + y * y);
        }

        public static float cartesianToPolarPhi(float x, float y) {
            return (float)Math.toDegrees(Math.atan2(y, x));
        }

        public static float polarToCartesianX(float r, float phi) {
            return r * (float)Math.cos(Math.toRadians(phi));
        }

        public static float polarToCartesianY(float r, float phi) {
            return r * (float)Math.sin(Math.toRadians(phi));
        }

        public static float lookAngleY(Vec3 lookAngle) {
            return CoordinateSystems.cartesianToPolarPhi((float)lookAngle.x(), (float)lookAngle.z()) + 270.0f;
        }
    }
}

