/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.structures.BuriedStargate;

public class TreasureMapForEmeraldsTrade
implements VillagerTrades.ItemListing {
    protected final int emeraldCost;
    protected final TagKey<Structure> destination;
    protected final String displayName;
    protected final Holder<MapDecorationType> destinationType;
    protected final int maxUses;
    protected final int villagerXp;

    public TreasureMapForEmeraldsTrade(int emeraldCost, TagKey<Structure> destination, String displayName, Holder<MapDecorationType> destinationType, int maxUses, int villagerXp) {
        this.emeraldCost = emeraldCost;
        this.destination = destination;
        this.displayName = displayName;
        this.destinationType = destinationType;
        this.maxUses = maxUses;
        this.villagerXp = villagerXp;
    }

    @Nullable
    public MerchantOffer getOffer(Entity entity, RandomSource source) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos blockpos = level2.findNearestMapStructure(this.destination, entity.blockPosition(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.create((Level)level2, (int)blockpos.getX(), (int)blockpos.getZ(), (byte)2, (boolean)true, (boolean)true);
                MapItem.renderBiomePreviewMap((ServerLevel)level2, (ItemStack)itemstack);
                MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", this.destinationType);
                itemstack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.displayName));
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCost), Optional.of(new ItemCost((ItemLike)Items.COMPASS)), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
        return null;
    }

    public static class StargateMapTrade
    extends TreasureMapForEmeraldsTrade {
        public StargateMapTrade(int emeraldCost, String displayName, int villagerXp) {
            super(emeraldCost, TagInit.Structures.STARGATE_MAP, displayName, (Holder<MapDecorationType>)MapDecorationTypes.RED_X, 1, villagerXp);
        }

        @Override
        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource source) {
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                int xOffset = 16 * (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
                int zOffset = 16 * (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
                StargateJourney.LOGGER.info("Attempting to locate Buried Stargate for map");
                BlockPos blockpos = level2.findNearestMapStructure(this.destination, new BlockPos(xOffset, 0, zOffset), 150, true);
                if (blockpos == null && level2.dimension().equals(Level.OVERWORLD)) {
                    StargateJourney.LOGGER.info("Couldn't locate Buried Stargate, falling back to BlockPos saved in BuriedStargate");
                    blockpos = new BlockPos(16 * BuriedStargate.getX(level2.getSeed()), 0, 16 * BuriedStargate.getZ(level2.getSeed()));
                }
                if (blockpos != null) {
                    ItemStack itemstack = MapItem.create((Level)level2, (int)blockpos.getX(), (int)blockpos.getZ(), (byte)2, (boolean)true, (boolean)true);
                    MapItem.renderBiomePreviewMap((ServerLevel)level2, (ItemStack)itemstack);
                    MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (Holder)this.destinationType);
                    itemstack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.displayName));
                    return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCost), Optional.of(new ItemCost((ItemLike)Items.COMPASS)), itemstack, this.maxUses, this.villagerXp, 0.2f);
                }
            }
            return null;
        }
    }
}

